% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bijectors.R
\name{tfb_real_nvp}
\alias{tfb_real_nvp}
\title{RealNVP affine coupling layer for vector-valued events}
\usage{
tfb_real_nvp(
  num_masked,
  shift_and_log_scale_fn,
  is_constant_jacobian = FALSE,
  validate_args = FALSE,
  name = NULL
)
}
\arguments{
\item{num_masked}{integer indicating that the first d units of the event
should be masked. Must be in the closed interval \verb{[1, D-1]}, where D
is the event size of the base distribution.}

\item{shift_and_log_scale_fn}{Function which computes shift and log_scale from both the
forward domain (x) and the inverse domain (y).
Calculation must respect the "autoregressive property". Suggested default:
\code{tfb_real_nvp_default_template(hidden_layers=...)}.
Typically the function contains \code{tf$Variables} and is wrapped using \code{tf$make_template}.
Returning NULL for either (both) shift, log_scale is equivalent to (but more efficient than) returning zero.}

\item{is_constant_jacobian}{Logical, default: FALSE. When TRUE the implementation assumes log_scale
does not depend on the forward domain (x) or inverse domain (y) values.
(No validation is made; is_constant_jacobian=FALSE is always safe but possibly computationally inefficient.)}

\item{validate_args}{Logical, default FALSE. Whether to validate input with asserts. If validate_args is
FALSE, and the inputs are invalid, correct behavior is not guaranteed.}

\item{name}{name prefixed to Ops created by this class.}
}
\value{
a bijector instance.
}
\description{
Real NVP models a normalizing flow on a D-dimensional distribution via a
single D-d-dimensional conditional distribution (Dinh et al., 2017):
\code{y[d:D] = x[d:D] * tf.exp(log_scale_fn(x[0:d])) + shift_fn(x[0:d])}
\code{y[0:d] = x[0:d]}
The last D-d units are scaled and shifted based on the first d units only,
while the first d units are 'masked' and left unchanged. Real NVP's
shift_and_log_scale_fn computes vector-valued quantities.
For scale-and-shift transforms that do not depend on any masked units, i.e.
d=0, use the tfb_affine bijector with learned parameters instead.
Masking is currently only supported for base distributions with
event_ndims=1. For more sophisticated masking schemes like checkerboard or
channel-wise masking (Papamakarios et al., 2016), use the tfb_permute
bijector to re-order desired masked units into the first d units. For base
distributions with event_ndims > 1, use the tfb_reshape bijector to
flatten the event shape.
}
\details{
Recall that the MAF bijector (Papamakarios et al., 2016) implements a
normalizing flow via an autoregressive transformation. MAF and IAF have
opposite computational tradeoffs - MAF can train all units in parallel but
must sample units sequentially, while IAF must train units sequentially but
can sample in parallel. In contrast, Real NVP can compute both forward and
inverse computations in parallel. However, the lack of an autoregressive
transformations makes it less expressive on a per-bijector basis.

A "valid" shift_and_log_scale_fn must compute each shift (aka loc or
"mu" in Papamakarios et al. (2016) and log(scale) (aka "alpha" in
Papamakarios et al. (2016)) such that each are broadcastable with the
arguments to forward and inverse, i.e., such that the calculations in
forward, inverse below are possible. For convenience,
real_nvp_default_nvp is offered as a possible shift_and_log_scale_fn function.

NICE (Dinh et al., 2014) is a special case of the Real NVP bijector
which discards the scale transformation, resulting in a constant-time
inverse-log-determinant-Jacobian. To use a NICE bijector instead of Real
NVP, shift_and_log_scale_fn should return (shift, NULL), and
is_constant_jacobian should be set to TRUE in the RealNVP constructor.
Calling tfb_real_nvp_default_template with shift_only=TRUE returns one such
NICE-compatible shift_and_log_scale_fn.

Caching: the scalar input depth D of the base distribution is not known at
construction time. The first call to any of forward(x), inverse(x),
inverse_log_det_jacobian(x), or forward_log_det_jacobian(x) memoizes
D, which is re-used in subsequent calls. This shape must be known prior to
graph execution (which is the case if using \code{tf$layers}).
}
\section{References}{

\itemize{
\item \href{https://arxiv.org/abs/1705.07057}{George Papamakarios, Theo Pavlakou, and Iain Murray. Masked Autoregressive Flow for Density Estimation. In \emph{Neural Information Processing Systems}, 2017.}
\item \href{https://arxiv.org/abs/1605.08803}{Laurent Dinh, Jascha Sohl-Dickstein, and Samy Bengio. Density Estimation using Real NVP. In \emph{International Conference on Learning Representations}, 2017.}
\item \href{https://arxiv.org/abs/1410.8516}{Laurent Dinh, David Krueger, and Yoshua Bengio. NICE: Non-linear Independent Components Estimation.\emph{arXiv preprint arXiv:1410.8516},2014.}
\item \href{https://blog.evjang.com/2018/01/nf2.html}{Eric Jang. Normalizing Flows Tutorial, Part 2: Modern Normalizing Flows. Technical Report_, 2018.}
}
}

\seealso{
For usage examples see \code{\link[=tfb_forward]{tfb_forward()}}, \code{\link[=tfb_inverse]{tfb_inverse()}}, \code{\link[=tfb_inverse_log_det_jacobian]{tfb_inverse_log_det_jacobian()}}.

Other bijectors: 
\code{\link{tfb_absolute_value}()},
\code{\link{tfb_affine_linear_operator}()},
\code{\link{tfb_affine_scalar}()},
\code{\link{tfb_affine}()},
\code{\link{tfb_ascending}()},
\code{\link{tfb_batch_normalization}()},
\code{\link{tfb_blockwise}()},
\code{\link{tfb_chain}()},
\code{\link{tfb_cholesky_outer_product}()},
\code{\link{tfb_cholesky_to_inv_cholesky}()},
\code{\link{tfb_correlation_cholesky}()},
\code{\link{tfb_cumsum}()},
\code{\link{tfb_discrete_cosine_transform}()},
\code{\link{tfb_expm1}()},
\code{\link{tfb_exp}()},
\code{\link{tfb_ffjord}()},
\code{\link{tfb_fill_scale_tri_l}()},
\code{\link{tfb_fill_triangular}()},
\code{\link{tfb_glow}()},
\code{\link{tfb_gompertz_cdf}()},
\code{\link{tfb_gumbel_cdf}()},
\code{\link{tfb_gumbel}()},
\code{\link{tfb_identity}()},
\code{\link{tfb_inline}()},
\code{\link{tfb_invert}()},
\code{\link{tfb_iterated_sigmoid_centered}()},
\code{\link{tfb_kumaraswamy_cdf}()},
\code{\link{tfb_kumaraswamy}()},
\code{\link{tfb_lambert_w_tail}()},
\code{\link{tfb_masked_autoregressive_default_template}()},
\code{\link{tfb_masked_autoregressive_flow}()},
\code{\link{tfb_masked_dense}()},
\code{\link{tfb_matrix_inverse_tri_l}()},
\code{\link{tfb_matvec_lu}()},
\code{\link{tfb_normal_cdf}()},
\code{\link{tfb_ordered}()},
\code{\link{tfb_pad}()},
\code{\link{tfb_permute}()},
\code{\link{tfb_power_transform}()},
\code{\link{tfb_rational_quadratic_spline}()},
\code{\link{tfb_rayleigh_cdf}()},
\code{\link{tfb_real_nvp_default_template}()},
\code{\link{tfb_reciprocal}()},
\code{\link{tfb_reshape}()},
\code{\link{tfb_scale_matvec_diag}()},
\code{\link{tfb_scale_matvec_linear_operator}()},
\code{\link{tfb_scale_matvec_lu}()},
\code{\link{tfb_scale_matvec_tri_l}()},
\code{\link{tfb_scale_tri_l}()},
\code{\link{tfb_scale}()},
\code{\link{tfb_shifted_gompertz_cdf}()},
\code{\link{tfb_shift}()},
\code{\link{tfb_sigmoid}()},
\code{\link{tfb_sinh_arcsinh}()},
\code{\link{tfb_sinh}()},
\code{\link{tfb_softmax_centered}()},
\code{\link{tfb_softplus}()},
\code{\link{tfb_softsign}()},
\code{\link{tfb_split}()},
\code{\link{tfb_square}()},
\code{\link{tfb_tanh}()},
\code{\link{tfb_transform_diagonal}()},
\code{\link{tfb_transpose}()},
\code{\link{tfb_weibull_cdf}()},
\code{\link{tfb_weibull}()}
}
\concept{bijectors}
