% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_fn.R
\name{input_fn}
\alias{input_fn}
\alias{input_fn.default}
\alias{input_fn.formula}
\alias{input_fn.data.frame}
\alias{input_fn.list}
\alias{input_fn.matrix}
\title{Construct an Input Function}
\usage{
input_fn(object, ...)

\method{input_fn}{default}(object, ...)

\method{input_fn}{formula}(object, data, ...)

\method{input_fn}{data.frame}(object, features, response = NULL,
  batch_size = 128, shuffle = "auto", num_epochs = 1,
  queue_capacity = 1000, num_threads = 1, ...)

\method{input_fn}{list}(object, features, response = NULL, batch_size = 128,
  shuffle = "auto", num_epochs = 1, queue_capacity = 1000,
  num_threads = 1, ...)

\method{input_fn}{matrix}(object, ...)
}
\arguments{
\item{object, data}{An 'input source' -- either a data set (e.g. an \R \code{data.frame}),
or another kind of object that can provide the data required for training.}

\item{...}{Optional arguments passed on to implementing submethods.}

\item{features}{The names of feature variables to be used.}

\item{response}{The name of the response variable.}

\item{batch_size}{The batch size.}

\item{shuffle}{Whether to shuffle the queue. When \code{"auto"} (the default),
shuffling will be performed except when this input function is called by
a \code{predict()} method.}

\item{num_epochs}{The number of epochs to iterate over data.}

\item{queue_capacity}{The size of queue to accumulate.}

\item{num_threads}{The number of threads used for reading and enqueueing. In
order to have predictable and repeatable order of reading and enqueueing,
such as in prediction and evaluation mode, \code{num_threads} should be 1.}
}
\description{
This function constructs input function from various types of input used to
feed different TensorFlow estimators.
}
\details{
For list objects, this method is particularly useful when constructing
dynamic length of inputs for models like recurrent neural networks. Note that
some arguments are not available yet for input_fn applied to list objects.
See S3 method signatures below for more details.
}
\examples{
\dontrun{
# Construct the input function through formula interface
input_fn1 <- input_fn(mpg ~ drat + cyl, mtcars)
}

\dontrun{
# Construct the input function from a data.frame object
input_fn1 <- input_fn(mtcars, response = mpg, features = c(drat, cyl))
}

\dontrun{
# Construct the input function from a list object
input_fn1 <- input_fn(
   object = list(
     feature1 = list(
       list(list(1), list(2), list(3)),
       list(list(4), list(5), list(6))),
     feature2 = list(
       list(list(7), list(8), list(9)),
       list(list(10), list(11), list(12))),
     response = list(
       list(1, 2, 3), list(4, 5, 6))),
   features = c("feature1", "feature2"),
   response = "response",
   batch_size = 10L)
}

}
\seealso{
Other input functions: \code{\link{numpy_input_fn}}
}
