% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iterators.R
\name{make-iterator}
\alias{make-iterator}
\alias{make_iterator_one_shot}
\alias{make_iterator_initializable}
\alias{make_iterator_from_structure}
\alias{make_iterator_from_string_handle}
\title{Creates an iterator for enumerating the elements of this dataset.}
\usage{
make_iterator_one_shot(dataset)

make_iterator_initializable(dataset, shared_name = NULL)

make_iterator_from_structure(
  output_types,
  output_shapes = NULL,
  shared_name = NULL
)

make_iterator_from_string_handle(
  string_handle,
  output_types,
  output_shapes = NULL
)
}
\arguments{
\item{dataset}{A dataset}

\item{shared_name}{(Optional) If non-empty, the returned iterator will be
shared under the given name across multiple sessions that share the same
devices (e.g. when using a remote server).}

\item{output_types}{A nested structure of tf$DType objects corresponding to
each component of an element of this iterator.}

\item{output_shapes}{(Optional) A nested structure of tf$TensorShape objects
corresponding to each component of an element of this dataset. If omitted,
each component will have an unconstrainted shape.}

\item{string_handle}{A scalar tensor of type string that evaluates
to a handle produced by the \code{\link[=iterator_string_handle]{iterator_string_handle()}} method.}
}
\value{
An Iterator over the elements of this dataset.
}
\description{
Creates an iterator for enumerating the elements of this dataset.
}
\section{Initialization}{

For \code{make_iterator_one_shot()}, the returned
iterator will be initialized automatically. A "one-shot" iterator does not
currently support re-initialization.

For \code{make_iterator_initializable()},
the returned iterator will be in an uninitialized state, and you must run
the object returned from \code{\link[=iterator_initializer]{iterator_initializer()}} before using it.

For \code{make_iterator_from_structure()}, the returned iterator is not bound
to a particular dataset, and it has no initializer. To initialize the
iterator, run the operation returned by \code{\link[=iterator_make_initializer]{iterator_make_initializer()}}.
}

\seealso{
Other iterator functions: 
\code{\link{iterator_get_next}()},
\code{\link{iterator_initializer}()},
\code{\link{iterator_make_initializer}()},
\code{\link{iterator_string_handle}()}
}
\concept{iterator functions}
