% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolate.R
\name{tf_interpolate}
\alias{tf_interpolate}
\alias{tf_interpolate.tfb}
\alias{tf_interpolate.tfd}
\title{Re-evaluate \code{tf}-objects on a new grid of argument values.}
\usage{
tf_interpolate(object, arg, ...)

\method{tf_interpolate}{tfb}(object, arg, ...)

\method{tf_interpolate}{tfd}(object, arg, ...)
}
\arguments{
\item{object}{an object inheriting from \code{tf}}

\item{arg}{a vector of argument values on which to evaluate the functions in
\code{object}}

\item{...}{additional arguments handed over to \code{tfd} or \code{tfb}, for the
construction of the returned object}
}
\value{
a \code{tfd} or \code{tfb} object on the new grid given by \code{arg}
}
\description{
Change the internal representation of a \code{tf}-object so that it
uses a different grid of argument values (\code{arg}). Useful for
\itemize{
\item thinning out dense grids to make data smaller
\item filling out sparse grids to make derivatives/integrals and locating extrema
or zero crossings more accurate (... \emph{if} the interpolation works well ...)
\item making irregular functional data into (more) regular data.
}

For \code{tfd}-objects, this is just syntactic sugar for \code{tfd(object, arg = arg)}.
To inter/extrapolate more reliably and avoid \code{NA}s, call
\code{tf_interpolate} with \code{evaluator = tf_approx_fill_extend}.\cr
For \code{tfb}-objects, this re-evaluates basis functions on the new grid which can
speed up subsequent computations if they all use that grid.
NB: \strong{To reliably impute very irregular data on a regular, common grid,
you'll be better off doing FPCA-based imputation or other model-based
approaches in most cases.}
}
\examples{
\donttest{
# thinning out a densely observed tfd
dense <- tf_rgp(10, arg = seq(0, 1, length.out = 1001))
less_dense <- tf_interpolate(dense, arg = seq(0, 1, length.out = 101))
dense
less_dense
# filling out sparse data (use a suitable evaluator-function!)
sparse <- tf_rgp(10, arg = seq(0, 5, length.out = 11))
plot(sparse, points = TRUE)
# change evaluator for better interpolation
tfd(sparse, evaluator = tf_approx_spline) |>
  tf_interpolate(arg = seq(0, 5, length.out = 201)) |>
  lines(col = 2, lty = 2)

set.seed(1860)
sparse_irregular <- tf_rgp(5) |>
  tf_sparsify(0.5) |>
  tf_jiggle()
tf_interpolate(sparse_irregular, arg = seq(0, 1, length.out = 51))
}
}
\seealso{
\code{\link[=tf_rebase]{tf_rebase()}}, which is more general.

Other tidyfun inter/extrapolation functions: 
\code{\link{tf_approx_linear}()},
\code{\link{tf_evaluate}()}
}
\concept{tidyfun inter/extrapolation functions}
\concept{tidyfun setters}
