% Generated by roxygen2 (4.0.2): do not edit by hand
\name{calc.loss}
\alias{calc.loss}
\title{Calculate total loss of model (Squared hinge loss).}
\usage{
calc.loss(model.blob, new.text = NULL, new.labeling = NULL,
  loss = c("square.hinge", "square", "hinge"))
}
\arguments{
\item{model.blob}{The model returned from \code{\link{textreg}}}

\item{new.text}{New text (string or tm Corpus) to predict labeling for}

\item{new.labeling}{Labeling to go with new text.}

\item{loss}{Type of loss to calc for.}
}
\value{
Three numbers: total loss, loss from prediction, loss from penalty term
}
\description{
Calculate the loss for a model in predicting the -1/+1 labeling.
If new text and labeling given, then calc loss on the new text and labeling.
This can be useful for cross validation and train-test splits.
}
\examples{
data( testCorpora )
res = textreg( c( "", "", "A", "A" ), c( -1, -1, 1, 1 ), C=1, Lq=1,
          convergence.threshold=0.00000001, verbosity=0 )
calc.loss( res )
calc.loss( res, new.text=c("A B C A"), new.labeling=c(1) )
}

