% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/textreg.R
\name{build.corpus}
\alias{build.corpus}
\title{Build a corpus that can be used in the textreg call.}
\usage{
build.corpus(corpus, labeling, banned = NULL, verbosity = 1,
  token.type = "word")
}
\arguments{
\item{corpus}{A list of strings or a corpus from the \code{tm} package.}

\item{labeling}{A vector of +1/-1 or TRUE/FALSE indicating which documents are considered relevant
and which are baseline.  The +1/-1 can contain 0 whcih means drop the document.}

\item{banned}{List of words that should be dropped from consideration.}

\item{verbosity}{Level of output.  0 is no printed output.}

\item{token.type}{"word" or "character" as tokens.}
}
\value{
A \code{\link{textreg.result}} object.
}
\description{
Pre-building a corpus allows for calling multiple textregs without doing a lot
of initial data processing (e.g., if you want to explore different ban lists or
regularization parameters)
}
\details{
See the bathtub vignette for more complete discussion of this method and the options
you might pass to it.
}
\note{
Unfortunately, the process of seperating out the textreg call and the build.corpus
    call is not quite as clean as one would hope.  The build.corpus call moves the text into
    the C++ memory, but the way the search tree is built for the regression it is hard to salvage
    it across runs and so this is of limited use.  In particular, the labeling and banned words
    cannot be easily changed.   Future versions of the package should remedy this.
}
\examples{
data( testCorpora )
textreg( testCorpora$testI$corpus, testCorpora$testI$labelI, c(), C=1, verbosity=1 )
}

