% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_document.R
\name{read_document}
\alias{read_document}
\title{Generic Function to Read in a Document}
\usage{
read_document(file, combine = FALSE, format = FALSE, ...)
}
\arguments{
\item{file}{The path to the a .pdf, .txt, .html, .docx, or .doc file.}

\item{combine}{logical.  If \code{TRUE} the vector is concatenated into a
single string via \code{\link[textshape]{combine}}.}

\item{format}{For .doc files only.  Logical.  If \code{TRUE} the output will
keep doc formatting (e.g., bold, italics, underlined).  This corresponds to
the \code{-f} flag in antiword.}

\item{\ldots}{Other arguments passed to \code{\link[textreadr]{read_pdf}},
\code{\link[textreadr]{read_html}}, \code{\link[textreadr]{read_docx}},
\code{\link[textreadr]{read_doc}}, or \code{\link[base]{readLines}}.}
}
\value{
Returns a \code{\link[base]{list}} of string \code{\link[base]{vector}}s.
}
\description{
Generic function to read in a .pdf, .txt, .html, .docx, or .doc file.
}
\examples{
## .pdf
pdf_doc <- system.file("docs/rl10075oralhistoryst002.pdf",
    package = "textreadr")
read_document(pdf_doc)

## .html
html_doc <- system.file("docs/textreadr_creed.html", package = "textreadr")
read_document(html_doc)

## .docx
docx_doc <- system.file("docs/Yasmine_Interview_Transcript.docx",
    package = "textreadr")
read_document(docx_doc)

## .doc
doc_doc <- system.file("docs/Yasmine_Interview_Transcript.doc",
    package = "textreadr")
read_document(doc_doc)

## .txt
txt_doc <- system.file('docs/textreadr_creed.txt', package = "textreadr")
read_document(txt_doc)

\dontrun{
## URLs
read_document('http://www.talkstats.com/index.php')
}
}

