% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcTopicModelR2.R
\name{CalcTopicModelR2}
\alias{CalcTopicModelR2}
\title{Calculate the R-squared of a topic model.}
\usage{
CalcTopicModelR2(dtm, phi, theta, ...)
}
\arguments{
\item{dtm}{A documents by terms dimensional document term matrix of class
\code{dgCMatrix} or of class \code{matrix}.}

\item{phi}{A topics by terms dimensional matrix where each entry is p(term_i |topic_j)}

\item{theta}{A documents by topics dimensional matrix where each entry is p(topic_j|document_d)}

\item{...}{Other arguments to be passed to \code{\link[textmineR]{TmParallelApply}}. See note, below.}
}
\value{
Returns an object of class \code{numeric} representing the proportion of variability
in the data that is explained by the topic model.
}
\description{
Function to calculate R-squared for a topic model. 
This uses a geometric interpretation of R-squared as the proportion of total distance 
each document is from the center of all the documents that is explained by the model.
}
\note{
This function performs parallel computation if \code{dtm} has more than 3,000
rows. The default is to use all available cores according to \code{\link[parallel]{detectCores}}.
However, this can be modified by passing the \code{cpus} argument when calling
this function.
}
\examples{
# Load a pre-formatted dtm and topic model
data(nih_sample_dtm) 
data(nih_sample_topic_model)

# Get the R-squared of the model
r2 <- CalcTopicModelR2(dtm = nih_sample_dtm, 
                     phi = nih_sample_topic_model$phi, 
                     theta = nih_sample_topic_model$theta)


r2
}
