% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Vec2Dtm.R
\name{Vec2Dtm}
\alias{Vec2Dtm}
\title{Convert a character vector to a document term matrix of class Matrix.}
\usage{
Vec2Dtm(vec, docnames = names(vec), min.n.gram = 1, max.n.gram = 1,
  remove.stopwords = TRUE, custom.stopwords = NULL, lower = TRUE,
  remove.punctuation = TRUE, remove.numbers = TRUE,
  stem.document = FALSE, ...)
}
\arguments{
\item{vec}{A character vector of documents.}

\item{docnames}{A vector of names for your documents. Defaults to 
\code{names(doc_vec)}. If NULL, then docnames is set to be 
\code{1:length(doc_vec)}.}

\item{min.n.gram}{The minimum size of n for creating n-grams. Defaults to 1.}

\item{max.n.gram}{The maximum size of n for creating n-grams. Defaults to 1. 
Numbers greater than 3 are discouraged due to risk of overfitting.}

\item{remove.stopwords}{Do you want to remove standard stopwords from your documents? 
Defaults to \code{TRUE}.}

\item{custom.stopwords}{If not \code{NULL} (the default) a character vector 
of stopwords to remove from your corpus.}

\item{lower}{Do you want all words coerced to lower case? Defaults to \code{TRUE}}

\item{remove.punctuation}{Do you want to convert all non-alpha numeric 
characters to spaces? Defaults to \code{TRUE}}

\item{remove.numbers}{Do you want to convert all numbers to spaces? Defaults 
to \code{TRUE}}

\item{stem.document}{Do you want to stem the words in your document using 
Porter's word stemmer? Defaults to \code{FALSE}}

\item{...}{Other arguments to be passed to \code{\link[textmineR]{TmParallelApply}}.}
}
\value{
A document term matrix of class \code{dgCMatrix}. The rows index 
documents. The columns index terms. The i, j entries represent the count of 
term j appearing in document i.
}
\description{
This function is deprecated. Use \code{\link[textmineR]{CreateDtm}}
             instead.
}
\examples{
\dontrun{
data(nih_sample)


dtm <- Vec2Dtm(vec = nih_sample$ABSTRACT_TEXT,
               docnames = nih_sample$APPLICATION_ID, 
               min.n.gram = 1, max.n.gram = 2)

dim(dtm)

head(colnames(dtm))

head(rownames(dtm))
}
}
