% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{text_file_parser}
\alias{text_file_parser}
\title{text file parser}
\usage{
text_file_parser(input_path_file = NULL, output_path_file = NULL,
  start_query = NULL, end_query = NULL, min_lines = 1,
  trimmed_line = FALSE, verbose = FALSE)
}
\arguments{
\item{input_path_file}{a character string specifying the path to the input file}

\item{output_path_file}{a character string specifying the path to the output file}

\item{start_query}{a character string. The \emph{start_query} is the first word of the subset of the data and should appear frequently at the beginning of each line in the text file.}

\item{end_query}{a character string. The \emph{end_query} is the last word of the subset of the data and should appear frequently at the end of each line in the text file.}

\item{min_lines}{a numeric value specifying the minimum number of lines. For instance if min_lines = 2, then only subsets of text with more than 1 lines will be kept.}

\item{trimmed_line}{either TRUE or FALSE. If FALSE then each line of the text file will be trimmed both sides before applying the start_query and end_query}

\item{verbose}{either TRUE or FALSE. If TRUE then information will be printed in the console}
}
\description{
text file parser
}
\details{
The text file should have a structure (such as an xml-structure), so that subsets can be extracted using the \emph{start_query} and \emph{end_query} parameters.
}
\examples{

library(textTinyR)

# fp = text_file_parser(input_path_file = '/folder/input_data.txt',

#                       output_path_file = '/folder/output_data.txt',

#                       start_query = 'word_a', end_query = 'word_w',

#                       min_lines = 1, trimmed_line = FALSE)
}

