% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,zeroinfl-method}
\alias{extract,zeroinfl-method}
\alias{extract.zeroinfl}
\title{\code{\link{extract}} method for \code{zeroinfl} objects}
\usage{
\S4method{extract}{zeroinfl}(
  model,
  beside = FALSE,
  include.count = TRUE,
  include.zero = TRUE,
  include.aic = TRUE,
  include.loglik = TRUE,
  include.nobs = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{beside}{Arrange the model terms below each other or beside each other?
The binary model parameters and the count parameters can be displayed in
two separate columns of the table.}

\item{include.count}{Report the count parameters in the coefficients block
(before the binary part for the zeros)?}

\item{include.zero}{Should the binary part of the model be included in the
coefficients block (after the count parameters)?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{zeroinfl} objects created by the
\code{\link[pscl]{zeroinfl}} function in the \pkg{pscl} package.
}
