% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texreg.R
\name{customcolumnnames}
\alias{customcolumnnames}
\title{Determine column names or column types if custom columns are present}
\usage{
customcolumnnames(modelnames, custom.columns, custom.col.pos, types = FALSE)
}
\arguments{
\item{modelnames}{A \code{character} vector of original model names, before
any custom columns are inserted.}

\item{custom.columns}{The same argument as specified in the
\code{link{matrixreg}} function.}

\item{custom.col.pos}{The same argument as specified in the
\code{link{matrixreg}} function.}

\item{types}{Return the column types? If \code{FALSE}, the column names in
the possible presence of custom columns are returned.}
}
\value{
A \code{character} vector with column names or types in the possible
  presence of custom columns. If \code{types = TRUE}, the vector contains
  the values \code{"coefnames"} (for the first column), \code{"coef"} (for
  columns with coefficients), or \code{"customcol"} (for custom new columns).
}
\description{
Determine column names or column types if custom columns are present.
}
\details{
This function takes model names (as saved in the attributes of a matrix
generated by \code{\link{matrixreg}}, for example) and the
\code{custom.columns} and \code{custom.col.pos} arguments of
\code{link{matrixreg}} or related functions and determines the column types
(\code{"coefnames"}, \code{"coef"}, or \code{"customcol"}) or model names in
the presence of custom columns.
}
\seealso{
\code{\link{matrixreg}}
}
\author{
Philip Leifeld
}
\keyword{internal}
