% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/texmexFamily.R
\name{texmexFamily}
\alias{texmexFamily}
\alias{print.texmexFamily}
\alias{summary.texmexFamily}
\alias{gpd}
\alias{gpdIntCensored}
\alias{glo}
\alias{gev}
\alias{egp3}
\alias{cgpd}
\alias{weibull}
\alias{gumbel}
\alias{print.summary.texmexFamily}
\title{Create families of distributions}
\usage{
texmexFamily(name, log.lik, param, info = NULL, sandwich =
    NULL, start = NULL, resid = NULL, rl, delta, endpoint, density,
    rng, prob, quant)
    \method{print}{texmexFamily}(x,...)
    \method{summary}{texmexFamily}(object,...)
    \method{print}{summary.texmexFamily}(x,...)
}
\arguments{
\item{name}{The name of the distribution.}

\item{log.lik}{The distribution's log-likelihood function.}

\item{param}{The names of the parameters in the model.}

\item{info}{Function to compute the information matrix. If not
provided, the modelling functions will work with a numerical
approximation.}

\item{sandwich}{Function to compute the filling in the Huber
sandwich estimator of the covariance matrix of parameter
estimates, used for dependent data. Only implemented in family
\code{gpd}.}

\item{start}{Function to compute starting parameters for the
model. If not provided, the modelling functions will try to
guess.}

\item{resid}{Function to compute residuals for the model.}

\item{rl}{Function to compute return levels.}

\item{delta}{Function to compute adjustments for covariance for
return levels.}

\item{endpoint}{Function to compute the upper or lower endpoint of
the fitted distribution.}

\item{density}{Function to compute the density.}

\item{rng}{Function for random number generation.}

\item{prob}{Function to compute cumulative probabilities.}

\item{quant}{Function to compute quantiles.}

\item{...}{Additional arguments to the print and summary methods.}

\item{x, object}{An object of class 'texmexFamily'.}
}
\value{
A object of class "texmexFamily", which is essentially a
    list containing the input arguments. If \code{info},
    \code{sandwich}, \code{start}, \code{resid} are not provided,
    they default to \code{NULL}.
}
\description{
Create families of distributions for use with extreme value
modelling.
}
\details{
The \code{density}, \code{rng}, \code{prob} and \code{quant}
functions can be simple wrappers for the usual d, r, p and q
functions. They should take a matrix with number of columns equal
to the number of parameters, and a fitted model object even if the
model object is not used by the function.

Examples of "texmexFamily" objects are \code{gpd}, \code{gev}, \code{glo},
\code{gpdIntCensored}, \code{weibull}, \code{gumbel} and \code{egp3}.  Take a look at
those objects to see how the functions should be constructed.

The functions are used by the modelling functions to create
diagnostic plots, predictions, etc..
}
\note{
The \code{gpd}, \code{gev}, \code{weibull}, generalised logistic (\code{glo}), 
\code{gumbel}, \code{gpdIntCensored} and \code{egp3} families are provided. 
The \code{\link{evm}} function defaults to using the \code{gpd} family.
}
\seealso{
\code{\link{evm}}
}
\author{
Harry Southworth
}
\keyword{models}
