\name{migpdCoefs}
\alias{migpdCoefs}
\title{ Change values of parameters in a migpd object }
\description{
  Change the values of parameters in a \code{migpd} object. You
  might want to do this after modelling marginal distributions
  as functions of covariates.
}
\usage{
migpdCoefs(object, which, coefs)
}
\arguments{
  \item{object}{ An object of class \code{migpd}. }
  \item{which}{ Which models in the \code{migpd} object you want to change. }
  \item{coefs}{ The coefficients that you want to change to. If \code{which}
                has length 1, \code{coefs} can be a vector of parameters.
                Otherwise, it should be a list of vectors, and the list should
                have the same length as \code{which} }
}

\value{
  A \code{migpd} object. See the help for \code{\link{migpd}}.
}

\author{ Harry Southworth }
\seealso{ \code{\link{migpd}} }
\examples{
library(MASS)
liver <- liver
liver$ndose <- as.numeric(liver$dose)
d <- data.frame(alt = resid(rlm(log(ALT.M) ~ log(ALT.B) + ndose, data=liver)),
                ast = resid(rlm(log(AST.M) ~ log(AST.B) + ndose, data=liver)),
                alp = resid(rlm(log(ALP.M) ~ log(ALP.B) + ndose, data=liver)),
                tbl = resid(rlm(log(TBL.M) ~ log(TBL.B) + ndose, data=liver)))

Dgpds <- migpd(d[liver$dose == "D", 1:4], mqu=.7)

d$ndose <- liver$ndose
galt <- gpd(alt, data=d, qu=.7, xi = ~ ndose)
gast <- gpd(ast, data=d, qu=.7, xi = ~ ndose)
galp <- gpd(alp, data=d, qu=.7, xi = ~ ndose)

altco <- predict(galt,type="lp",newdata=data.frame(ndose=4))[1:2]
astco <- predict(gast,type="lp",newdata=data.frame(ndose=4))[1:2]
alpco <- predict(galp,type="lp",newdata=data.frame(ndose=4))[1:2]

Dgpd <- migpdCoefs(Dgpds, which=c("alt", "ast", "alp"),
                   coefs=list(altco, astco, alpco))
                   
summary(Dgpd)
summary(Dgpds)

}
\keyword{ multivariate }

