% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_test_subdir.R
\name{use_test_subdir}
\alias{use_test_subdir}
\alias{use_integration_tests}
\alias{use_acceptance_tests}
\alias{use_manual_tests}
\title{Use test subdirectories}
\usage{
use_test_subdir(path, make_tester = TRUE, ignore_tester = TRUE)

use_integration_tests()

use_acceptance_tests()

use_manual_tests()
}
\arguments{
\item{path}{\code{character} scalar. Will be processed with \code{\link[base:make.names]{base::make.names()}} to
make a syntactically valid name.}

\item{make_tester}{\code{logical} or \code{character} scalar. Create an R script with a
test helper function. If \code{TRUE} an R script file will be placed into the
\file{R/} directory of the current package, containing a function definition
for running the tests in \code{path}. The file will be named
\file{testthis-testers.R}, but you can specify  your own name by
passing a character scalar to \code{make_tester()}. See \code{\link[=use_tester]{use_tester()}} for details.}

\item{ignore_tester}{\code{logical} scalar`. Add \file{tester} file to \file{.Rbuildignore}?}
}
\value{
\code{TRUE} on success (invisibly).
}
\description{
Create a subdir in \file{tests/testthat/} and optionally an R script
containing a helper function to run all tests in that subdir. Useful for
separating long-running tests from your unit tests, or storing tests that
you do not want to run on CRAN or during R CMD Check. For running tests in
\file{tests/testthat/} subdirectories see \code{\link[=test_subdir]{test_subdir()}}.
}
\section{Test subdirectory presets}{


Three preset test subdirs are defined at the moment:

\describe{
\item{\code{test_integration()}}{Integration tests, also called component tests.
Put tests here that test if several functions / parts of your program
work together as expected. You can create the relevant subdir
\file{testthat/integration_tests/} with \code{use_integration_tests()}.\preformatted{}
}

\item{\code{test_acceptance()}}{Acceptance tests. This is the highest levels of
tests. Put tests here that verifies if your package fulfills the
goals/requirements you set out to achieve with your package were met.
You can create the relevant subdir \file{testthat/acceptance_tests/}
with \code{use_acceptance_tests()}.
}
\item{\code{test_manual()}}{Manual tests. Put tests here that produce output
that has to be manually verified, such as: console output, pdf files,
plots. It is recommended you collect the output files of such tests in
\file{tests/testthat/testout}. You can create the relevant subdir
with \file{testthat/manual_tests/} with \code{use_manual_tests()}.}
}

You can modify the default paths for manual, acceptance and integration tests
by setting the respective \code{options()}, but it is recommended to create your
own test subdirs instead.
}

\examples{
\dontrun{
use_test_subdir("special_tests", make_tester = TRUE)

## Reload the Package manually...
## Create some tests in tests/testthat/test_special_tests/

test_special_tests()
}

}
\seealso{
\code{\link[=test_subdir]{test_subdir()}}

Other infrastructure: \code{\link{use_testdata}},
  \code{\link{use_tester}}
}
\concept{infrastructure}
