% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/expectations-matches.R
\name{matching-expectations}
\alias{expect_error}
\alias{expect_match}
\alias{expect_message}
\alias{expect_output}
\alias{expect_warning}
\alias{matching-expectations}
\title{Expectation: does string/output/warning/error match a regular expression?}
\usage{
expect_match(object, regexp, ..., all = TRUE, info = NULL, label = NULL)

expect_output(object, regexp, ..., info = NULL, label = NULL)

expect_error(object, regexp = NULL, ..., info = NULL, label = NULL)

expect_warning(object, regexp = NULL, ..., all = FALSE, info = NULL,
  label = NULL)

expect_message(object, regexp = NULL, ..., all = FALSE, info = NULL,
  label = NULL)
}
\arguments{
\item{object}{object to test}

\item{regexp}{regular expression to test against. If ommited,
just asserts that code produces some output, messsage, warning or
error.}

\item{...}{Additional arguments passed on to \code{\link{grepl}}, e.g.
\code{ignore.case} or \code{fixed}.}

\item{all}{should all elements of actual value match \code{regexp} (TRUE),
or does only one need to match (FALSE)}

\item{info}{extra information to be included in the message (useful when
writing tests in loops).}

\item{label}{object label. When \code{NULL}, computed from deparsed object.}
}
\description{
Expectation: does string/output/warning/error match a regular expression?
}
\examples{
expect_match("Testing is fun", "fun")
expect_match("Testing is fun", "f.n")

# Output --------------------------------------------------------------------
str(mtcars)
expect_output(str(mtcars), "32 obs")
expect_output(str(mtcars), "11 variables")

# You can use the arguments of grepl to control the matching
expect_output(str(mtcars), "11 VARIABLES", ignore.case = TRUE)
expect_output(str(mtcars), "$ mpg", fixed = TRUE)

# Messages ------------------------------------------------------------------

f <- function(x) {
  if (x < 0) message("*x* is already negative")
  -x
}
expect_message(f(-1))
expect_message(f(-1), "already negative")
\dontrun{expect_message(f(1))}

# You can use the arguments of grepl to control the matching
expect_message(f(-1), "*x*", fixed = TRUE)
expect_message(f(-1), "NEGATIVE", ignore.case = TRUE)

# Warnings --------------------------------------------------------------------
f <- function(x) {
  if (x < 0) warning("*x* is already negative")
  -x
}
expect_warning(f(-1))
expect_warning(f(-1), "already negative")
\dontrun{expect_warning(f(1))}

# You can use the arguments of grepl to control the matching
expect_warning(f(-1), "*x*", fixed = TRUE)
expect_warning(f(-1), "NEGATIVE", ignore.case = TRUE)


# Errors --------------------------------------------------------------------
f <- function() stop("My error!")
expect_error(f())
expect_error(f(), "My error!")

# You can use the arguments of grepl to control the matching
expect_error(f(), "my error!", ignore.case = TRUE)
}
\seealso{
Other expectations: \code{\link{equivalence}},
  \code{\link{expect_equal}},
  \code{\link{expect_equivalent}},
  \code{\link{expect_identical}};
  \code{\link{expect-compare}},
  \code{\link{expect_less_than}},
  \code{\link{expect_more_than}};
  \code{\link{expect_equal_to_reference}};
  \code{\link{expect_false}}, \code{\link{expect_true}};
  \code{\link{expect_is}}; \code{\link{expect_named}};
  \code{\link{expect_null}}; \code{\link{takes_less_than}}
}

