% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect-datacomp.R
\name{datacomp-expectations}
\alias{datacomp-expectations}
\alias{expect_valmatch}
\alias{expect_subset}
\title{Expectations: comparisons}
\usage{
expect_valmatch(
  data2,
  vars,
  by,
  not = FALSE,
  flt = TRUE,
  data = get_testdata()
)

expect_subset(data2, by = NULL, not = FALSE, flt = TRUE, data = get_testdata())
}
\arguments{
\item{data2}{The data frame to compare against.}

\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{by}{A character vector of columns to join by. See \code{\link[dplyr:mutate-joins]{dplyr::join()}} for
details.}

\item{not}{Reverse the results of the check?}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

These functions allow for comparison between two data frames.
}
\details{
\itemize{
\item \code{expect_valmatch()} compares the observations appearing in one data frame
(\code{data}) to the same observations, as picked out by a key (\code{by}), in another
data frame (\code{data2}). It fails if the selected columns (\code{vars}) aren't the
same for those observations in both data frames.
\item \code{expect_subset()} compares one data frame (\code{data}) to another (\code{data2}) and
fails if all of the observations in the first, as picked out by a key (\code{by}),
do not appear in the second.
}
}
\examples{

df1 <- data.frame(
  id = 0:99,
  binomial = sample(0:1, 100, TRUE),
  even = abs(0:99\%\%2 - 1) * 0:99
)

df2 <- data.frame(
  id = 0:99,
  binomial = sample(0:1, 100, TRUE),
  odd = 0:99\%\%2 *0:99
)


# Check that same records 'succeeded' across data frames
try(expect_valmatch(df2, binomial, by = "id", data = df1))

# Check that all records in `df1`, as picked out by `id`, exist in `df2`
expect_subset(df2, by = "id", data = df1)

}
\seealso{
Other data expectations: 
\code{\link{conditional-expectations}},
\code{\link{date-expectations}},
\code{\link{exclusivity-expectations}},
\code{\link{generic-expectations}},
\code{\link{label-expectations}},
\code{\link{pattern-expectations}},
\code{\link{proportion-expectations}},
\code{\link{text-expectations}},
\code{\link{uniqueness-expectations}},
\code{\link{value-expectations}}
}
\concept{data expectations}
