% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_proportion.R
\name{estimate_proportions}
\alias{estimate_proportions}
\alias{s_proportion}
\alias{a_proportion}
\alias{estimate_proportion}
\title{Estimation of Proportions}
\usage{
s_proportion(
  df,
  .var,
  conf_level = 0.95,
  method = c("waldcc", "wald", "clopper-pearson", "wilson", "wilsonc", "strat_wilson",
    "strat_wilsonc", "agresti-coull", "jeffreys"),
  weights = NULL,
  max_iterations = 50,
  variables = list(strata = NULL),
  long = FALSE
)

a_proportion(
  df,
  .var,
  conf_level = 0.95,
  method = c("waldcc", "wald", "clopper-pearson", "wilson", "wilsonc", "strat_wilson",
    "strat_wilsonc", "agresti-coull", "jeffreys"),
  weights = NULL,
  max_iterations = 50,
  variables = list(strata = NULL),
  long = FALSE
)

estimate_proportion(
  lyt,
  vars,
  ...,
  show_labels = "hidden",
  table_names = vars,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)
}
\arguments{
\item{df}{(\code{logical} or \code{data.frame})\cr if only a logical vector is used,
it indicates whether each subject is a responder or not. \code{TRUE} represents
a successful outcome. If a \code{data.frame} is provided, also the \code{strata} variable
names must be provided in \code{variables} as a list element with the strata strings.
In the case of \code{data.frame}, the logical vector of responses must be indicated as a
variable name in \code{.var}.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{method}{(\code{string})\cr the method used to construct the confidence interval
for proportion of successful outcomes; one of \code{waldcc}, \code{wald}, \code{clopper-pearson},
\code{wilson}, \code{wilsonc}, \code{strat_wilson}, \code{strat_wilsonc}, \code{agresti-coull} or \code{jeffreys}.}

\item{weights}{(\code{numeric} or \code{NULL})\cr weights for each level of the strata. If \code{NULL}, they are
estimated using the iterative algorithm proposed in \insertCite{Yan2010-jt;textual}{tern} that
minimizes the weighted squared length of the confidence interval.}

\item{max_iterations}{(\code{count})\cr maximum number of iterations for the iterative procedure used
to find estimates of optimal weights.}

\item{variables}{(named \code{list} of \code{string})\cr list of additional analysis variables.}

\item{long}{(\code{flag})\cr a long description is required.}

\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{vars}{(\code{character})\cr variable names for the primary analysis variable to be iterated over.}

\item{...}{other arguments are ultimately conveyed to \code{\link[=s_proportion]{s_proportion()}}.}

\item{show_labels}{(\code{string})\cr label visibility: one of "default", "visible" and "hidden".}

\item{table_names}{(\code{character})\cr this can be customized in case that the same \code{vars} are analyzed multiple times,
to avoid warnings from \code{rtables}.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
\itemize{
\item \code{s_proportion()} returns statistics \code{n_prop} (\code{n} and proportion) and \code{prop_ci} (proportion CI) for a
given variable.
}

\itemize{
\item \code{a_proportion()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{estimate_proportion()} returns a layout object suitable for passing to further layouting functions,
or to \code{\link[rtables:build_table]{rtables::build_table()}}. Adding this function to an \code{rtable} layout will add formatted rows containing
the statistics from \code{s_proportion()} to the table layout.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Estimate the proportion of responders within a studied population.
}
\section{Functions}{
\itemize{
\item \code{s_proportion()}: Statistics function estimating a
proportion along with its confidence interval.

\item \code{a_proportion()}: Formatted analysis function which is used as \code{afun}
in \code{estimate_proportion()}.

\item \code{estimate_proportion()}: Layout-creating function which can take statistics function arguments
and additional format arguments. This function is a wrapper for \code{\link[rtables:analyze]{rtables::analyze()}}.

}}
\examples{
# Case with only logical vector.
rsp_v <- c(1, 0, 1, 0, 1, 1, 0, 0)
s_proportion(rsp_v)

# Example for Stratified Wilson CI
nex <- 100 # Number of example rows
dta <- data.frame(
  "rsp" = sample(c(TRUE, FALSE), nex, TRUE),
  "grp" = sample(c("A", "B"), nex, TRUE),
  "f1" = sample(c("a1", "a2"), nex, TRUE),
  "f2" = sample(c("x", "y", "z"), nex, TRUE),
  stringsAsFactors = TRUE
)

s_proportion(
  df = dta,
  .var = "rsp",
  variables = list(strata = c("f1", "f2")),
  conf_level = 0.90,
  method = "strat_wilson"
)

dta_test <- data.frame(
  USUBJID = paste0("S", 1:12),
  ARM     = rep(LETTERS[1:3], each = 4),
  AVAL    = c(A = c(1, 1, 1, 1), B = c(0, 0, 1, 1), C = c(0, 0, 0, 0))
)

basic_table() \%>\%
  split_cols_by("ARM") \%>\%
  estimate_proportion(vars = "AVAL") \%>\%
  build_table(df = dta_test)

}
\seealso{
\link{h_proportions}
}
