data(rbmi_test_data)
dat <- rbmi_test_data

testthat::test_that("tidy.pool is produced correctly", {
  result <- broom::tidy(dat)[, -1]

  expected <- data.frame(
    c(
      "-1.61581995766697", "-1.70762640404516", "-4.22512642519727", "-2.87379756893085",
      "-6.38102548405994", "-4.15873766528714", "-7.58026593671547", "-4.76040605665019"
    ),
    c(
      "0.486231596928312", "0.474957263044525", "0.655676842047498", "0.647945143653854",
      "0.703415648968908", "0.696416461146921", "0.790726132680671", "0.755712890509359"
    ),
    c(
      "-2.57577141468279", "-2.64531930504159", "-5.52033399517686", "-4.15418494506937",
      "-7.77106696884431", "-5.53562139985044", "-9.14479557479419", "-6.25429347896141"
    ),
    c(
      "-0.655868500651147", "-0.769933503048726", "-2.92991885521768", "-1.59341019279232",
      "-4.99098399927558", "-2.78185393072384", "-6.01573629863675", "-3.26651863433897"
    ),
    c(NA, "-0.0918064463781925", NA, "1.35132885626642", NA, "2.22228781877281", NA, "2.81985988006528"),
    c(NA, "0.68262790574849", NA, "0.921893782421201", NA, "0.97529650168225", NA, "1.0846000605867"),
    c(NA, "-1.43949684096095", NA, "-0.46983381835952", NA, "0.295711719695827", NA, "0.675944089854828"),
    c(NA, "1.25588394820457", NA, "3.17249153089236", NA, "4.14886391784979", NA, "4.96377567027573"),
    c(NA, "0.893177242657404", NA, "0.144732721791534", NA, "0.024056863075852", NA, "0.0103032263522642"),
    c(NA, "0.056817249930957", NA, "-0.319831579052295", NA, "-0.348264996641084", NA, "-0.372000125537433"),
    c("4", "4", "5", "5", "6", "6", "7", "7"),
    c("0.95", "0.95", "0.95", "0.95", "0.95", "0.95", "0.95", "0.95"),
    stringsAsFactors = FALSE
  ) %>%
    dplyr::mutate(dplyr::across(everything(), as.numeric))

  colnames(expected) <- c(
    "est", "se_est", "lower_cl_est", "upper_cl_est", "est_contr", "se_contr",
    "lower_cl_contr", "upper_cl_contr", "p_value", "relative_reduc", "visit", "conf_level"
  )

  expected$visit <- as.factor(expected$visit)
  testthat::expect_identical(result, expected, tolerance = 0.000001)
})
