% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialize.R
\name{init_tergmLite}
\alias{init_tergmLite}
\title{Initializes EpiModel netsim Object for tergmLite Simulation}
\usage{
init_tergmLite(dat)
}
\arguments{
\item{dat}{A list object containing a \code{networkDynamic} object and other
initialization information passed from \code{netsim}.}
}
\value{
Returns the list object \code{dat} and adds two elements to the objects: \code{el}
is an edgelist representation of the network; and \code{p} is a list object
that contains all the relevant structural information for ERGM/TERGM simulation.
The function also removes the network class object on the \code{dat} object,
stored under \code{nw} because it is no longer needed.
}
\description{
Initializes EpiModel netsim Object for tergmLite Simulation
}
\details{
This function is typically used within the initialization modules of
\code{EpiModel} to establish the necessary \code{networkLite} infrastructure
needed for \code{tergmLite} network resimulation. Specifically, this function
converts (and then removes) the \code{network} class objects into an edgelist
only format and prepares the ERGM structural information for simulation. The
example below demonstrates the specific information returned.

Implemented terms are:
\itemize{
  \item edges
  \item nodematch
  \item nodefactor
  \item concurrent (including heterogenous by attribute)
  \item degree (including heterogenous by attribute)
  \item degrange
  \item absdiff
  \item absdiffby (in the EpiModel package)
  \item nodecov
  \item nodemix
  \item absdiffnodemix (in the EpiModel package)
  \item triangle
  \item gwesp(fixed=TRUE)
  \item mean.age
}
All other terms will return errors.
}
\examples{
\dontrun{
library("EpiModel")
nw <- network_initialize(100)
formation <- ~edges
target.stats <- 50
coef.diss <- dissolution_coefs(dissolution = ~offset(edges), duration = 20)
x <- netest(nw, formation, target.stats, coef.diss, verbose = FALSE)

param <- param.net(inf.prob = 0.3)
init <- init.net(i.num = 10)
control <- control.net(type = "SI", nsteps = 100, nsims = 5, tergmLite = TRUE)

# networkLite representation after initialization
dat <- crosscheck.net(x, param, init, control)
dat <- initialize.net(x, param, init, control)
str(dat, max.level = 1)

# networkLite representation used by tergmLite
str(dat$p, max.level = 3)

# Elements removed are nw (network class object)
# Elements added are el (edgelist representation of network)...
dat$el

# ... and p (contains all relevant ERGM structural information for simulation)
str(dat$p, max.level = 3)
}

}
