% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_tensor.R
\name{polar}
\alias{polar}
\title{The left polar decomposition.}
\usage{
polar(X)
}
\arguments{
\item{X}{A matrix.}
}
\value{
\code{P} A \eqn{n} by \eqn{n} symmetric positive definite
    matrix.

\code{Z} A \eqn{n} by \eqn{p} matrix with orthonormal rows.

Note that \code{X == P \%*\% Z}, up to numerical precision.
}
\description{
\code{polar} calculates the left polar decomposition of a matrix.
}
\details{
\code{polar} Takes a matrix \eqn{X}, of dimensions \eqn{n} by
\eqn{p}, and returns two matrices \eqn{P} and \eqn{Z} such that
\eqn{X = PZ}. \eqn{P} is a symmetric positive definite matrix of
dimension \eqn{n} by \eqn{n} and \eqn{Z} is an \eqn{n} by \eqn{p}
matrix with orthonormal rows.
}
\examples{
X <- matrix(1:6, nrow = 2)
polar_x <- polar(X)
P <- polar_x$P
Z <- polar_x$Z
P
Z
trim(Z \%*\% t(Z))
trim(X - P \%*\% Z)
}
\author{
David Gerard.
}

