% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfunction.R
\name{theta_to_p}
\alias{theta_to_p}
\title{The probability matrix given latent parameters}
\usage{
theta_to_p(theta,omega)
}
\arguments{
\item{theta}{a continuous-valued tensor (latent parameters)}

\item{omega}{the cut-off points}
}
\value{
a probability matrix in which the number of columns is possible outcomes and each row vector is corresponding probabilities at an entry of the tensor
}
\description{
Compute the probability matrix given latent parameters from the cumulative model
}
\examples{
indices <- c(10,20,30)
arr <- array(runif(prod(indices),-2,2),dim = indices)
b <- c(-1.5,0,1.5)
probability <- theta_to_p(arr,b);probability
}
