% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigmaD.R
\name{sigmaD}
\alias{sigmaD}
\title{HAC covariance estimator for asymptotic normality on each row j of loading matrix estimator}
\usage{
sigmaD(k, D, Q, C, Y, j, beta = 0)
}
\arguments{
\item{k}{Mode of loading matrix.}

\item{D}{Eigenvalue matrix of sample covariance matrix, with dimension rk by rk.}

\item{Q}{Estimated mode-k loading matrix, with dimension Ik by rk.}

\item{C}{Estimated common component series, written in an array with dimension K+1 and mode-1 as the time mode.}

\item{Y}{Observed time series with missingness allowed, written in an array with dimension K+1 and mode-1 as the time mode.}

\item{j}{Integer representing the row of mode-k loading matrix. Value should be integers from minimum 1 to maximum Ik.}

\item{beta}{Lag parameter of the HAC type. Default is 0.}
}
\value{
A matrix of dimension rk by rk
}
\description{
Computing the HAC covariance estimator for asymptotic normality on each row j of the mode-k loading matrix estimator, with maximum order of tensor time series as 3
}
\examples{
K = 3;
TT = 10;
d = c(20,20,20);
r = c(2,2,2);
re = c(2,2,2);
eta = list(c(0,0), c(0,0), c(0,0));
coef_f = c(0.7, 0.3, -0.4, 0.2, -0.1);
coef_fe = c(-0.7, -0.3, -0.4, 0.2, 0.1);
coef_e = c(0.8, 0.4, -0.4, 0.2, -0.1);
data_test = tensor_gen(K,TT,d,r,re,eta, coef_f, coef_fe, coef_e);
data_miss = miss_gen(data_test$X);
data_est = miss_factor_est(data_miss, r);
D = diag(x=(svd(data_est$covMatrix[[2]])$d)[1:2], nrow=2, ncol=2);
sigmaD(2, D, data_est$A[[2]], data_est$imputation, data_miss, 2, 2);



}
