% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempdisagg-package.R
\docType{package}
\name{tempdisagg-package}
\alias{tempdisagg-package}
\alias{tempdisagg}
\title{Methods for Temporal Disaggregation and Interpolation of Time Series}
\description{
Temporal disaggregation methods are used to disaggregate or
interpolate a low frequency time series to higher frequency series, where
either the sum, the average, the first or the last value of the resulting
high frequency series is consistent with the low frequency series. Temporal
disaggregation can be performed with or without one or more high frequency
indicator series.

A good way to start is the introductory vignette:

\code{vignette("intro", "tempdisagg")}

Our article on temporal disaggregation of time series
(\url{https://doi.org/10.32614/RJ-2013-028}) in the R-Journal describes the
package and the theory of temporal disaggregation in more detail.
}
\seealso{
\code{\link[=td]{td()}} for more information on usage.
}
\author{
Christoph Sax \email{christoph.sax@gmail.com}, Peter Steiner
}
\keyword{package}
