% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcata.R
\encoding{UTF-8}
\name{bootstrap.band}
\alias{bootstrap.band}
\title{Get bootstrap confidence bands for attribute selections}
\usage{
bootstrap.band(X, boot = 999, alpha = 0.05, return.bias = FALSE)
}
\arguments{
\item{X}{data frame of indicator data (with possible values \code{0} or \code{1})}

\item{boot}{number of virtual panels}

\item{alpha}{alpha level for bootstrap confidence bands}

\item{return.bias}{indicates whether to return bias associated with bootstrap mean value}
}
\value{
\code{lcl} lower \code{100(alpha/2)\%} bootstrap confidence limit

\code{ccl} upper \code{100(1 - alpha/2)\%} bootstrap confidence limit

\code{bias} provided if \code{output.bias = TRUE}
}
\description{
Get bootstrap confidence bands for TCATA attribute citation rates or TDS attribute dominance rates.
}
\details{
Get bootstrap confidence bands for TCATA attribute citation rates or TDS attribute dominance rates.
}
\examples{
x <- ojtcata[ojtcata$samp == 1 & ojtcata$attribute == "Sweetness",  -c(1:4)]
x.boot.ci <- bootstrap.band(x, boot = 99) # 99 is only for illustrative purposes
x.boot.ci
}
