% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replymarkup.R
\name{ReplyKeyboardRemove}
\alias{ReplyKeyboardRemove}
\title{Remove a keyboard}
\usage{
ReplyKeyboardRemove(remove_keyboard = TRUE, selective = NULL)
}
\arguments{
\item{remove_keyboard}{Requests clients to remove the custom keyboard.
(user will not be able to summon this keyboard; if you want to hide
the keyboard from sight but keep it accessible, use
\code{one_time_keyboard} in \code{\link{ReplyKeyboardMarkup}}).
Defaults to \code{TRUE}.}

\item{selective}{(Optional). Use this parameter if you want to show the
keyboard to specific users only.}
}
\description{
Upon receiving a message with this object, Telegram clients will
remove the current custom keyboard and display the default
letter-keyboard. By default, custom keyboards are displayed until
a new keyboard is sent by a bot. An exception is made for one-time
keyboards that are hidden immediately after the user presses a
button (see \code{\link{ReplyKeyboardMarkup}}).
}
\examples{
\dontrun{
# Initialize bot
bot <- Bot(token = "TOKEN")
chat_id <- "CHAT_ID"

# Create Custom Keyboard
text <- "Don't forget to send me the answer!"
RKM <- ReplyKeyboardMarkup(
  keyboard = list(
    list(KeyboardButton("Yes, they certainly are!")),
    list(KeyboardButton("I'm not quite sure")),
    list(KeyboardButton("No..."))
  ),
  resize_keyboard = FALSE,
  one_time_keyboard = FALSE
)

# Send Custom Keyboard
bot$sendMessage(chat_id, text, reply_markup = RKM)

# Remove Keyboard
bot$sendMessage(
  chat_id,
  "Okay, thanks!",
  reply_markup = ReplyKeyboardRemove()
)
}
}
