% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replymarkup.R
\name{ReplyKeyboardMarkup}
\alias{ReplyKeyboardMarkup}
\title{Create a keyboard markup}
\usage{
ReplyKeyboardMarkup(keyboard, resize_keyboard = NULL,
  one_time_keyboard = NULL, selective = NULL)
}
\arguments{
\item{keyboard}{List of button rows, each represented by a list of
\code{\link{KeyboardButton}} objects.}

\item{resize_keyboard}{(Optional). Requests clients to resize the keyboard
vertically for optimal fit. Defaults to \code{FALSE}, in which case the
custom keyboard is always of the same height as the app's standard
keyboard.}

\item{one_time_keyboard}{(Optional). Requests clients to hide the keyboard
as soon as it's been used. The keyboard will still be available, but
clients will automatically display the usual letter-keyboard in the
chat - the user can press a special button in the input field to see the
custom keyboard again. Defaults to \code{FALSE}.}

\item{selective}{(Optional). Use this parameter if you want to show the
keyboard to specific users only.}
}
\description{
This object represents a
\href{https://core.telegram.org/bots#keyboards}{custom keyboard} with reply
options.
}
\examples{
\dontrun{
# Initialize bot
bot <- Bot(token = "TOKEN")
chat_id <- "CHAT_ID"

# Create Custom Keyboard
text <- "Aren't those custom keyboards cool?"
RKM <- ReplyKeyboardMarkup(
  keyboard = list(
    list(KeyboardButton("Yes, they certainly are!")),
    list(KeyboardButton("I'm not quite sure")),
    list(KeyboardButton("No..."))
  ),
  resize_keyboard = FALSE,
  one_time_keyboard = TRUE
)

# Send Custom Keyboard
bot$sendMessage(chat_id, text, reply_markup = RKM)
}
}
