% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card_section.R
\docType{class}
\name{card_section}
\alias{card_section}
\title{Create a \code{card_section} Structure With \code{teamr}}
\format{An \code{\link{R6Class}} generator object}
\usage{
# sec <- card_section$new()
}
\description{
\code{card_section} creates an \code{Section} object which can be added to \code{connector_card}.
}
\details{
Assemble \code{card_section} objects into a \code{action_card}
structure and use the methods to append, modify or send your card to the webhook specified.
}
\section{Methods}{


\describe{
\item{\code{card_section$new()}}{Creates a new \code{card_section}.}
\item{\code{text(sec_text)}}{Change the \code{text} field of the section.}
\item{\code{title(sec_title)}}{Change the \code{title} field of the section.}
\item{\code{activity_title(sec_activity_title)}}{Change the \code{title} field of the section.}
\item{\code{activity_sub_title(sec_activity_subtitle)}}{Change the \code{subtitle} field of the section.}
\item{\code{activity_image(sec_activity_image)}}{Change the \code{image} field of the section.}
\item{\code{activity_text(sec_activitiy_text)}}{Change the \code{text} field of the section.}
\item{\code{add_fact(fname, fvalue)}}{Add \code{fact} object to section.}
\item{\code{add_link_button(btext, burl)}}{Add button with links.}
\item{\code{add_image(sec_image, sec_title)}}{Change webhook address.}
\item{\code{print()}}{Print out the current payload.}
\item{\code{dump()}}{Dump current payload.}
}
}

\section{Properties}{


\describe{
\item{\code{payload}}{R list of payloads(will be parsed into json)\link[httr]{POST}}
}
}

\examples{
\dontrun{
library(teamr)

cc <- connector_card$new(hookurl = "https://outlook.office.com/webhook/...")
cc$text("Of on affixed civilly moments promise explain")
sec$text("2018-19 Finals MVP")
sec$activity_sub_title("Kawhi Leonard")
sec$add_fact("Position", "Forward")
sec$title("Player Info")
sec$add_image(sec_image = "https://....jpg", sec_title = "so funny")
sec$activity_image("https://.....jpg")
sec$activity_title("Activity Title")
sec$activity_sub_title("Activity Subtitle")
sec$activity_text("Activity text")
cc$add_section(new_section = sec)
cc$print()
cc$send()
}
}
\keyword{datasets}
