% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AddCardModule.R
\name{add_card_button_srv}
\alias{add_card_button_srv}
\title{Add Card Button Server}
\usage{
add_card_button_srv(id, reporter, card_fun)
}
\arguments{
\item{id}{\code{character(1)} this \code{shiny} module's id.}

\item{reporter}{\code{\link{Reporter}} instance.}

\item{card_fun}{\code{function} which returns a \code{\link{ReportCard}} instance. It can have optional \code{card}, \code{comment} and
\code{label} parameters. If \code{card} parameter is added, then the \code{ReportCard} instance is created for the user.
Use \code{comment} parameter to pass it's value whenever you prefer with \code{card$append_text()} - if \code{card_fun} does not
have \code{comment} parameter, then \code{comment} from \verb{Add Card UI} module will be added at the end of the content of the
card. If \code{label} parameter is provided, you can use it to customize appearance of the \verb{card name} and use if to
specify \code{card} content with \code{card$append_text()} - if \code{card_fun} does not have \code{label} parameter, then \verb{card name}
will be set to the name passed in \verb{Add Card UI} module, but no text will be added to the content of the \code{card}.}
}
\value{
\code{shiny::moduleServer}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
server for adding views/cards to the Report.

For more details see the vignette: \code{vignette("simpleReporter", "teal.reporter")}.
}
\details{
This module allows using a child of \code{\link{ReportCard}} instead of \code{\link{ReportCard}}.
To properly support this, an instance of the child class must be passed
as the default value of the \code{card} argument in the \code{card_fun} function.
See below:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{CustomReportCard <- R6::R6Class( # nolint: object_name_linter.
  classname = "CustomReportCard",
  inherit = teal.reporter::ReportCard
)

custom_function <- function(card = CustomReportCard$new()) \{
  card
\}
}\if{html}{\out{</div>}}
}
