% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdisc_data.R
\name{cdisc_data}
\alias{cdisc_data}
\title{Data input for \code{teal} app}
\usage{
cdisc_data(
  ...,
  join_keys = teal.data::default_cdisc_join_keys[names(rlang::list2(...))],
  code = character(0),
  check
)
}
\arguments{
\item{...}{any number of objects (presumably data objects) provided as \code{name = value} pairs.}

\item{join_keys}{(\code{join_keys} or single \code{join_key_set})
optional object with datasets column names used for joining.
If empty then it would be automatically derived basing on intersection of datasets primary keys.
For ADAM datasets it would be automatically derived.}

\item{code}{(\code{character}, \code{language}) optional code to reproduce the datasets provided in \code{...}.
Note this code is not executed and the \code{teal_data} may not be reproducible}

\item{check}{(\code{logical}) \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Use \code{\link[=verify]{verify()}} to verify code reproducibility .}
}
\value{
A \code{teal_data} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Function is a wrapper around \code{\link[=teal_data]{teal_data()}} and guesses \code{join_keys}
for given datasets whose names match ADAM datasets names.
}
\details{
This function checks if there were keys added to all data sets.
}
\examples{
data <- cdisc_data(
  join_keys = join_keys(
    join_key("ADSL", "ADTTE", c("STUDYID" = "STUDYID", "USUBJID" = "USUBJID"))
  )
)

data <- within(data, {
  ADSL <- example_cdisc_data("ADSL")
  ADTTE <- example_cdisc_data("ADTTE")
})

}
