% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qenv-get_code.R
\name{get_code}
\alias{get_code}
\alias{get_code,qenv-method}
\alias{get_code,qenv.error-method}
\title{Get code from \code{qenv}}
\usage{
get_code(object, deparse = TRUE)

\S4method{get_code}{qenv}(object, deparse = TRUE)

\S4method{get_code}{qenv.error}(object)
}
\arguments{
\item{object}{(\code{qenv})}

\item{deparse}{(\code{logical(1)}) if the returned code should be converted to character.}
}
\value{
named \code{character} with the reproducible code.
}
\description{
Get code from \code{qenv}
}
\examples{
q1 <- new_qenv(env = list2env(list(a = 1)), code = quote(a <- 1))
q2 <- eval_code(q1, code = quote(b <- a))
q3 <- eval_code(q2, code = quote(d <- 2))
get_code(q3)
get_code(q3, deparse = FALSE)
}
