% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{data.wdi.search}
\alias{data.wdi.search}
\title{Finds a Series in WDI Dataset}
\usage{
data.wdi.search(
  series,
  keywords,
  searchName = TRUE,
  searchDesc = FALSE,
  topicKeywords = NULL,
  findOne = FALSE
)
}
\arguments{
\item{series}{This must be the \code{series} field in the output of the \code{\link{data.wdi.agg}} function.}

\item{keywords}{A character array representing the keywords to be used for searching.}

\item{searchName}{A logical value indicating whether to search in the names field or not. If \code{FALSE}, it does not search in the names field.}

\item{searchDesc}{A logical value indicating whether to search in the description or not. If \code{FALSE}, it does not search in the description.}

\item{topicKeywords}{A character array representing the keywords that must be contained in the topic of a matched case.}

\item{findOne}{A logical value indicating whether to raise an error if more than one series is found. The default is \code{FALSE}.}
}
\value{
If \code{findOne} is \code{TRUE}, it returns a series information. Otherwise, it returns a list with series information.
}
\description{
Use this function to search for a series in the WDI dataset by its name, description, and some other attributes.
}
\examples{
#data <- data.wdi.agg() # this is time-consuming and requires WDI dataset files
#res <- data.wdi.search(data$series, c("GDP per capita"),
#                        TRUE, topicKeywords = "national account")
}
