% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frequency.R
\name{f.daily}
\alias{f.daily}
\title{Create a Daily Frequency}
\usage{
f.daily(date)
}
\arguments{
\item{date}{The date, which can be a list with \code{year}, \code{month}, and \code{day} elements.
It can also be an integer array with 3 elements for year, month, and day respectively,
or an object that can be used as an argument for the \code{base::as.Date} function.}
}
\value{
An object of class \code{ldtf}, which is also a list with the following members:
\item{class}{Determines the class of this frequency.}
\item{year}{Determines the \code{year}.}
\item{month}{Determines the \code{month}.}
\item{day}{Determines the \code{day}.}
}
\description{
Use this function to create a frequency for time-series data that occurs daily.
}
\details{
To use the \code{\link{as.frequency}} function for this type of frequency,
you need the following information:
\itemize{
\item \strong{Character Format} \code{"YYYYMMDD"} (similar to \code{Weekly})
\item \strong{Class Id} \code{"d"}
}
}
\examples{

d0 <- f.daily(c(2023, 1, 2)) # This is 2/1/2023. Next observation belongs to 3/1/2023.

d0_value_str <-  as.character(d0) # this will be '20230102'.
d0_class_str <- get.class.id(d0) # this will be 'd'.

d_new <- as.frequency("20230109", "d") # This is 9/1/2023.

# Don't use invalid or unsupported dates:
\donttest{
# d_invalid <- try(as.frequency("1399109", "d")) # this is a too old date and unsupported
# d_invalid <- try(as.frequency("20230132", "d")) # invalid day in month
d_invalid <- try(as.frequency("20231331", "d")) # invalid month
}

}
