% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acy.R
\name{acy}
\alias{acy}
\title{Activity Concentration y}
\usage{
acy(
  y,
  modpars,
  type = "hill",
  returntop = FALSE,
  returntoploc = FALSE,
  getloss = FALSE,
  poly2.biphasic = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{y}{Activity value at which the concentration is desired. y
should be less than the model's top, if there is one, and greater
than zero.}

\item{modpars}{List of named model parameters. Model parameters can
include: "a", "b", "ga", "la", "p", "q", "tp". ga and la should NOT
be in log units.}

\item{type}{Model type; must be one of: "exp1", "exp2", "exp3", "exp4",
"gnls", "hill",  "poly1", "poly2", "pow".}

\item{returntop}{When TRUE, returns actual top value for gnls. Has no
effect for other models.}

\item{returntoploc}{When TRUE, returns concentration of top for gnls.
Has no effect for other models. If top location can't be found,
NA is returned.}

\item{getloss}{When TRUE, returns value on loss side of curve for gnls.
Has no effect for other models.}

\item{poly2.biphasic}{If poly2.biphasic = TRUE, constraints are set to allow
for the polynomial 2 model fit to be bi-phasic (i.e. non-monotonic).}

\item{verbose}{When TRUE, shows warnings.}
}
\value{
Ouputs concentration at activity y, or gnls top or top concentration,
  when applicable.
}
\description{
Returns concentration at which model equals y.
}
\details{
Mathematically inverts model functions of the given type, except for gnls,
which is numerically inverted. gnls returns NA when y > tp. Other options
return the actual top (as opposed to theoretical tp) and top location for
gnls model. gnls model defaults to giving concentration on gain side. Only
one of getloss, returntop, and returntoploc should be TRUE at a time.  If
top location solution fails for gnls, top is set to tp. Returns NA if gnls
numerical solver fails. Returns NA if model was not successfully fit.
}
\examples{
acy(1, list(ga = 10, tp = 2, p = 3), type = "hill")
acy(1, list(ga = .1, tp = 2, p = 3, q = 3,la = 10), type = "gnls")
acy(1, list(ga = .1, tp = 2, p = 3, q = 3,la = 10), type = "gnls", getloss = TRUE)
acy(1, list(ga = .1, tp = 2, p = 3, q = 3,la = 10), type = "gnls", returntop = TRUE)
acy(1, list(ga = .1, tp = 2, p = 3, q = 3,la = 10), type = "gnls", returntoploc = TRUE)

}
