% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{print.sim_tci}
\alias{print.sim_tci}
\title{Print method for sim_tci class}
\usage{
\method{print}{sim_tci}(x, ...)
}
\arguments{
\item{x}{Object with class "sim_tci" created by `simulate_tci()`}

\item{...}{Other arguments. Not currently used.}
}
\value{
Prints a description of the simulation.
}
\description{
Print object with class "sim_tci" created by `simulate_tci()`.
}
\examples{
data <- data.frame(ID = 1:3, AGE = c(20,30,40), TBW = c(60,70,80),
HGT = c(150,160,170), MALE = c(TRUE,FALSE,TRUE))
pkmod_prior <- poppkmod(data, drug = "ppf", model = "eleveld")
pkmod_true  <- poppkmod(data, drug = "ppf", model = "eleveld", sample = TRUE)
obs_tms <- seq(1/6,10,1/6)
target_vals = c(75,60,50,50)
target_tms = c(0,3,6,10)

# open-loop simulation (without update_tms)
sim_ol <- simulate_tci(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms,
seed = 200)

# closed-loop simulation (with update_tms)
\dontrun{
sim_cl <- simulate_tci(pkmod_prior, pkmod_true, target_vals, target_tms, obs_tms,
update_tms = c(2,4,6,8), seed = 200)
}
}
