% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{init_poppkmod}
\alias{init_poppkmod}
\title{Initialize a `poppkmod` object.}
\usage{
init_poppkmod(data = NULL, drug = NULL, model = NULL, sample = NULL, PD = NULL)
}
\arguments{
\item{data}{Data frame of patient covariates. ID values, if used, should be in a column labeled "id" or "ID"}

\item{drug}{"ppf" for propofol or "remi" for remifentanil. Defaults to "ppf".}

\item{model}{Model name. Options are "marsh", "schnider", or "eleveld" if
drug = "ppf", or "minto", "kim", or "eleveld" if drug = "remi".}

\item{sample}{Logical. Should parameter values be sampled from interindividual distribution (TRUE)
or evaluated at point estimates for covariates (FALSE)? Defaults to FALSE.}

\item{PD}{Should the PD component be evaluated for PK-PD models. Defaults to TRUE.}
}
\value{
`poppkmod` object
}
\description{
Generate a `poppkmod` object from an existing population PK model
for propofol or remifentanil using patient covariates. Available models for
propofol are the Marsh, Schnider, and Eleveld models. Available models for
remifentanil are the Minto, Kim, and Eleveld models. Input is
a data frame with rows corresponding to individuals and columns
recording patient covariates.
}
\examples{
data <- data.frame(ID = 1:5, AGE = seq(20,60,by=10), TBW = seq(60,80,by=5),
HGT = seq(150,190,by=10), MALE = c(TRUE,TRUE,FALSE,FALSE,FALSE))
init_poppkmod(data, drug = "ppf", model = "eleveld")
init_poppkmod(data, drug = "remi", model = "kim")
}
