% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmers.R
\name{generate.kmers}
\alias{generate.kmers}
\alias{generate.kmers.prob}
\title{Generate k-mers.}
\usage{
generate.kmers(.k, .seq = '', .alphabet = c('A', 'C', 'G', 'T'))

generate.kmers.prob(.k, .probs, .count = 1, .alphabet = c('A', 'C', 'G', 'T'),
                    .last.nucl = 'X')
}
\arguments{
\item{.k}{Size of k-mers or either integer or vector with k-s for generate.kmers.prob.}

\item{.seq}{Prefix of all generated k-mers.}

\item{.alphabet}{Alphabet.}

\item{.probs}{Matrix with probabilities for generating adjacent symbol with |alphabet| X |alphabet| size. Order of letters is
given in the \code{.alphabet} parameter.}

\item{.count}{Number of kmers to be generated.}

\item{.last.nucl}{Adjacent nucleotide from which start generation. If 'X' than choose one of the nucleotides with equal probabilities.}
}
\value{
Vector of all possible k-mers for \code{generate.kmers}
or a vector of generated kmers for \code{generate.kmers.prob}.
}
\description{
Generate all k-mers. starting with the given sequence on the given alphabet
Generate k-mers with the given k and probabilities of nucleotides next to each other (markov chain).
}

