% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbr_sum.R
\name{tbr_sum}
\alias{tbr_sum}
\title{Time-Based Rolling Sum}
\usage{
tbr_sum(.tbl, x, tcolumn, unit = "years", n, na.rm = FALSE)
}
\arguments{
\item{.tbl}{a data frame with at least two variables; time column formatted
as date, date/time and value column.}

\item{x}{column containing the values to calculate the sum.}

\item{tcolumn}{formatted time column.}

\item{unit}{character, one of "years", "months", "weeks", "days", "hours",
"minutes", "seconds"}

\item{n}{numeric, describing the length of the time window.}

\item{na.rm}{logical. Should missing values be removed?}
}
\value{
dataframe with column for the rolling sum.
}
\description{
Time-Based Rolling Sum
}
\examples{
tbr_sum(Dissolved_Oxygen, x = Average_DO, tcolumn = Date, unit = "years", n =
5)
}
\seealso{
\code{\link{sum}}
}
