% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guess_taxo_rank.R
\name{guess_taxo_rank}
\alias{guess_taxo_rank}
\title{Guess the taxonomic rank of Scientific Name}
\usage{
guess_taxo_rank(name)
}
\arguments{
\item{name}{scientific name string to be checked}
}
\value{
\itemize{\item{"Genus or above"}{ = single word} \item{"Species"}{ = 
two words}  \item{"Subspecies"}{ = three words} \item{"Unknown"}{ = zero or 
more than three words}}
}
\description{
Guesses the taxonomic rank i.e. Genus, Species or Subspecies based on
number of words
}
\examples{
guess_taxo_rank("")
guess_taxo_rank("Akodon longipilis")
guess_taxo_rank("Akodon")
guess_taxo_rank("Abrocoma cinerea shistacea")
guess_taxo_rank("Abrocoma cinerea shistacea shistacea")
}
\seealso{
Other Name functions: 
\code{\link{build_gen_syn}()},
\code{\link{cast_canonical}()},
\code{\link{cast_scientificname}()},
\code{\link{check_scientific}()},
\code{\link{expand_name}()},
\code{\link{get_accepted_names}()},
\code{\link{list_higher_taxo}()},
\code{\link{melt_canonical}()},
\code{\link{melt_scientificname}()},
\code{\link{resolve_names}()},
\code{\link{taxo_fuzzy_match}()}
}
\concept{Name functions}
