% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxa.R
\name{accessionToTaxa}
\alias{accessionToTaxa}
\title{Convert accessions to taxa}
\usage{
accessionToTaxa(accessions, sqlFile)
}
\arguments{
\item{accessions}{a vector of NCBI accession strings to convert to taxa}

\item{sqlFile}{a string giving the path to a sqlite file screated by \code{\link{read.accession2taxid}}}
}
\value{
a vector of NCBI taxa ids
}
\description{
Convert a vector of NCBI accession numbers to their assigned taxonomy
}
\examples{
taxa<-c(
 "accession\\taccession.version\\ttaxid\\tgi",
 "Z17427\\tZ17427.1\\t3702\\t16569",
 "Z17428\\tZ17428.1\\t3702\\t16570",
 "Z17429\\tZ17429.1\\t3702\\t16571",
 "Z17430\\tZ17430.1\\t3702\\t16572",
 "X62402\\tX62402.1\\t9606\\t30394"
)
inFile<-tempfile()
sqlFile<-tempfile()
writeLines(taxa,inFile)
read.accession2taxid(inFile,sqlFile)
accessionToTaxa(c("Z17430.1","Z17429.1","X62402.1",'NOTREAL'),sqlFile)
}
\references{
\url{ftp://ftp.ncbi.nih.gov/pub/taxonomy/accession2taxid}
}
\seealso{
\code{\link{getTaxonomy}}, \code{\link{read.accession2taxid}}
}
