% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_methods.R
\name{get_validity}
\alias{get_validity}
\title{Validate entries of a merged taxonomy}
\usage{
get_validity(x, rank = "family", valid = TRUE)
}
\arguments{
\item{x}{A tibble created with \code{load_taxonomies()} or \code{load_population()} or \code{load_sample()}.}

\item{rank}{A string with GBIF rank that will be used to examine an NCBI lineage for validation purposes. Must
be kingdom, phylum, class, order or family. Defaults to family. Note: If "kingdom" is used, the
term_conversion() method should first be applied.}

\item{valid}{A logical indicating whether the returned data should include valid or invalid entries (defaults to valid).}
}
\value{
A validated tibble
}
\description{
Validate entries of a merged taxonomy
}
\examples{
get_validity(load_sample(), valid = TRUE)
}
