% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_children.R
\name{col_children}
\alias{col_children}
\title{Search Catalogue of Life for for direct children of a particular taxon.}
\usage{
col_children(name = NULL, id = NULL, format = NULL, start = NULL,
  checklist = NULL, extant_only = FALSE, ...)
}
\arguments{
\item{name}{The string to search for. Only exact matches found the name given
will be returned, unless one or wildcards are included in the search
string. An * (asterisk) character denotes a wildcard; a percent
character may also be used. The name must be at least 3 characters long,
not counting wildcard characters.}

\item{id}{The record ID of the specific record to return (only for scientific
names of species or infraspecific taxa)}

\item{format}{format of the results returned. Valid values are format=xml and
format=php; if the format parameter is omitted, the results are returned
in the default XML format. If format=php then results are returned as a
PHP array in serialized string format, which can be converted back to an
array in PHP using the unserialize command}

\item{start}{The first record to return. If omitted, the results are returned
from the first record (start=0). This is useful if the total number of
results is larger than the maximum number of results returned by a single
Web service query (currently the maximum number of results returned by a
single query is 500 for terse queries and 50 for full queries).}

\item{checklist}{The year of the checklist to query, if you want a specific
year's checklist instead of the lastest as default (numeric).}

\item{extant_only}{(logical) keep extant taxa only? default: \code{FALSE}
by default we give back all taxa. set to \code{TRUE} to get only
extant taxa}

\item{...}{Curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
A list of data.frame's, where each data.frame has columns:
\itemize{
\item childtaxa_id: (character) COL identifier
\item childtaxa_name: (character) taxonomic name
\item childtaxa_rank: (character) rank name
\item childtaxa_extinct: (logical) extinct or not
}
}
\description{
Search Catalogue of Life for for direct children of a particular taxon.
}
\details{
You must provide one of name or id. The other parameters (format
and start) are optional.
}
\section{Rate limiting}{

COL introduced rate limiting recently (writing this on 2019-11-14),
but we've no information on what the rate limits are. If you do run into
this you'll see an error like "Error: Too Many Requests (HTTP 429)",
you'll need to time your requests to avoid the rate limiting, for
example, by putting \code{Sys.sleep()} in between simultaneous requests.
}

\examples{
\dontrun{
# A basic example
col_children(name="Apis")

# An example where there is no classification, results in data.frame with
# no rows
col_children(id='b2f88f382aa5568f93a97472c6be6516')

# Use a specific year's checklist
col_children(name="Apis", checklist=2012)
col_children(name="Apis", checklist=2009)

# Pass in many names or many id's
out <- col_children(name=c("Buteo","Apis","Accipiter","asdf"),
  checklist = "2012")
out$Apis # get just the output you want
library("plyr")
ldply(out) # or combine to one data.frame

# or pass many id's
ids <- c('abe977b1d27007a76dd12a5c93a637bf',
  'b2f88f382aa5568f93a97472c6be6516')
out <- col_children(id = ids, checklist=2012)
library("plyr")
ldply(out) # combine to one data.frame

# keep extant taxa only, prunes out extinct taxa
col_children(name = "Insecta")
col_children(name = "Insecta", extant_only = TRUE)
}
}
