% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/limited_print.R
\name{limited_print}
\alias{limited_print}
\title{Print a subset of a character vector}
\usage{
limited_print(chars, prefix = "", max_chars = getOption("width") -
  nchar(prefix) - 5, type = "message")
}
\arguments{
\item{chars}{(\code{character}) What to print.}

\item{prefix}{(\code{character} of length 1) What to print before
\code{chars}, on the same line.}

\item{max_chars}{(\code{numeric} of length 1) The maximum number of
characters to print.}

\item{type}{(\code{"error"}, \code{"warning"}, \code{"message"}, \code{"cat"}, \code{"print"}, \code{"silent"})}
}
\value{
\code{NULL}
}
\description{
Prints the start and end values for a character vector. The number of values
printed depend on the width of the screen by default.
}
\examples{
\dontrun{
taxa:::limited_print(1:100)
taxa:::limited_print(1:10000)
taxa:::limited_print(1:10000, prefix = "stuff:")
}
}
\keyword{internal}
