% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{classification}
\alias{cbind.classification}
\alias{cbind.classification_ids}
\alias{classification}
\alias{classification.colid}
\alias{classification.default}
\alias{classification.eolid}
\alias{classification.gbifid}
\alias{classification.ids}
\alias{classification.nbnid}
\alias{classification.tpsid}
\alias{classification.tsn}
\alias{classification.uid}
\alias{rbind.classification}
\alias{rbind.classification_ids}
\title{Retrieve the taxonomic hierarchy for a given taxon ID.}
\usage{
classification(...)

\method{classification}{default}(x, db = NULL, callopts = list(),
  return_id = TRUE, rows = NA, ...)

\method{classification}{tsn}(id, callopts = list(), return_id = TRUE, ...)

\method{classification}{uid}(id, callopts = list(), return_id = TRUE, ...)

\method{classification}{eolid}(id, key = NULL, callopts = list(),
  return_id = TRUE, ...)

\method{classification}{colid}(id, start = NULL, checklist = NULL,
  callopts = list(), return_id = TRUE, ...)

\method{classification}{tpsid}(id, key = NULL, callopts = list(),
  return_id = TRUE, ...)

\method{classification}{gbifid}(id, callopts = list(), return_id = TRUE,
  ...)

\method{classification}{nbnid}(id, callopts = list(), return_id = TRUE, ...)

\method{classification}{ids}(id, ...)

cbind.classification(x)

rbind.classification(x)

cbind.classification_ids(...)

rbind.classification_ids(...)
}
\arguments{
\item{...}{Other arguments passed to \code{\link[taxize]{get_tsn}},
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{get_eolid}},
\code{\link[taxize]{get_colid}}, \code{\link[taxize]{get_tpsid}},
\code{\link[taxize]{get_gbifid}}.}

\item{x}{Vector of taxa names (character) or IDs (character or numeric) to query.}

\item{db}{character; database to query. either \code{ncbi}, \code{itis},
\code{eol}, \code{col}, \code{tropicos}, \code{gbif}, or \code{nbn}. Note
that each taxonomic data source has their own identifiers, so that if you
provide the wrong \code{db} value for the identifier you could get a result,
but it will likely be wrong (not what you were expecting).}

\item{callopts}{Curl options passed on to \code{\link[httr]{GET}}}

\item{return_id}{(logical) If TRUE (default), return the taxon id as well as the name
and rank of taxa in the lineage returned.}

\item{rows}{(numeric) Any number from 1 to infinity. If the default NA, all rows are
considered. Note that this parameter is ignored if you pass in a taxonomic id instead
of a name of class character.}

\item{id}{character; identifiers, returned by \code{\link[taxize]{get_tsn}},
\code{\link[taxize]{get_uid}}, \code{\link[taxize]{get_eolid}},
\code{\link[taxize]{get_colid}}, \code{\link[taxize]{get_tpsid}},
\code{\link[taxize]{get_gbifid}}.}

\item{key}{Your API key; loads from .Rprofile.}

\item{start}{The first record to return. If omitted, the results are returned
from the first record (start=0). This is useful if the total number of
results is larger than the maximum number of results returned by a single
Web service query (currently the maximum number of results returned by a
single query is 500 for terse queries and 50 for full queries).}

\item{checklist}{character; The year of the checklist to query, if you want a specific
year's checklist instead of the lastest as default (numeric).}
}
\value{
A named list of data.frames with the taxonomic classification of
   every supplied taxa.
}
\description{
Retrieve the taxonomic hierarchy for a given taxon ID.
}
\details{
If IDs are supplied directly (not from the \code{get_*} functions) you
must specify the type of ID. There is a timeout of 1/3 seconds between
querries to NCBI.

BEWARE: Right now, NBN doesn't return the queried taxon in the classification. But you can
attach it yourself quite easily of course. This behavior is different from the other data
sources.
}
\examples{
\dontrun{
# Plug in taxon IDs
classification(9606, db = 'ncbi')
classification(c(9606, 55062), db = 'ncbi')
classification(129313, db = 'itis')
classification(57361017, db = 'eol')
classification(c(2704179, 2441176), db = 'gbif')
classification(25509881, db = 'tropicos')
classification("NBNSYS0000004786", db = 'nbn')
## works the same if IDs are in class character
classification(c("2704179", "2441176"), db = 'gbif')

# Plug in taxon names
## in this case, we use get_*() fxns internally to first get taxon IDs
classification(c("Chironomus riparius", "aaa vva"), db = 'ncbi')
classification(c("Chironomus riparius", "aaa vva"), db = 'ncbi', verbose=FALSE)
classification(c("Chironomus riparius", "aaa vva"), db = 'itis')
classification(c("Chironomus riparius", "aaa vva"), db = 'itis', verbose=FALSE)
classification(c("Chironomus riparius", "aaa vva"), db = 'eol')
classification(c("Chironomus riparius", "aaa vva"), db = 'col')
classification("Alopias vulpinus", db = 'nbn')
classification(c("Chironomus riparius", "aaa vva"), db = 'col', verbose=FALSE)
classification(c("Chironomus riparius", "asdfasdfsfdfsd"), db = 'gbif')
classification("Poa annua", db = 'tropicos')

# Use methods for get_uid, get_tsn, get_eolid, get_colid, get_tpsid
classification(get_uid(c("Chironomus riparius", "Puma concolor")))

classification(get_uid(c("Chironomus riparius", "aaa vva")))
classification(get_tsn(c("Chironomus riparius", "aaa vva")))
classification(get_tsn(c("Chironomus riparius", "aaa vva"), verbose = FALSE))
classification(get_eolid(c("Chironomus riparius", "aaa vva")))
classification(get_colid(c("Chironomus riparius", "aaa vva")))
classification(get_tpsid(c("Poa annua", "aaa vva")))
classification(get_gbifid(c("Poa annua", "Bison bison")))

# Pass many ids from class "ids"
(out <- get_ids(names="Puma concolor", db = c('ncbi','gbif')))
(cl <- classification(out))

# Bind width-wise from class classification_ids
cbind(cl)

# Bind length-wise
rbind(cl)

# Many names to get_ids
(out <- get_ids(names=c("Puma concolor","Accipiter striatus"), db = c('ncbi','itis','col')))
(cl <- classification(out))
rbind(cl)
## cbind with so many names results in some messy data
cbind(cl)
## so you can turn off return_id
cbind( classification(out, return_id=FALSE) )

# rbind and cbind on class classification (from a call to get_colid, get_tsn, etc.
# - other than get_ids)
(cl_col <- classification(get_colid(c("Puma concolor","Accipiter striatus"))))
rbind(cl_col)
cbind(cl_col)

(cl_uid <- classification(get_uid(c("Puma concolor","Accipiter striatus")), return_id=FALSE))
rbind(cl_uid)
cbind(cl_uid)
## cbind works a bit odd when there are lots of ranks without names
(cl_uid <- classification(get_uid(c("Puma concolor","Accipiter striatus")), return_id=TRUE))
cbind(cl_uid)

(cl_tsn <- classification(get_tsn(c("Puma concolor","Accipiter striatus"))))
rbind(cl_tsn)
cbind(cl_tsn)

(tsns <- get_tsn(c("Puma concolor","Accipiter striatus")))
(cl_tsns <- classification(tsns))
cbind(cl_tsns)

# NBN data
(res <- classification(c("Alopias vulpinus","Pinus sylvestris"), db = 'nbn'))
rbind(res)
cbind(res)

# Return taxonomic IDs
## the return_id parameter is logical, and you can turn it on or off. It's TRUE by default
classification(c("Alopias vulpinus","Pinus sylvestris"), db = 'ncbi', return_id = TRUE)
classification(c("Alopias vulpinus","Pinus sylvestris"), db = 'ncbi', return_id = FALSE)

# Use rows parameter to select certain
classification('Poa annua', db = 'tropicos')
classification('Poa annua', db = 'tropicos', rows=1:4)
classification('Poa annua', db = 'tropicos', rows=1)
classification('Poa annua', db = 'tropicos', rows=6)
}

}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{get_uid}},
   \code{\link[taxize]{get_eolid}}, \code{\link[taxize]{get_colid}},
   \code{\link[taxize]{get_tpsid}}, \code{\link[taxize]{get_gbifid}}
}

