% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/get_uid.R
\name{get_uid}
\alias{as.data.frame.uid}
\alias{as.uid}
\alias{as.uid.character}
\alias{as.uid.data.frame}
\alias{as.uid.list}
\alias{as.uid.numeric}
\alias{as.uid.uid}
\alias{get_uid}
\alias{get_uid_}
\title{Get the UID codes from NCBI for taxonomic names.}
\usage{
get_uid(sciname, ask = TRUE, verbose = TRUE, rows = NA)

as.uid(x, check = TRUE)

\method{as.uid}{uid}(x, check = TRUE)

\method{as.uid}{character}(x, check = TRUE)

\method{as.uid}{list}(x, check = TRUE)

\method{as.uid}{numeric}(x, check = TRUE)

\method{as.uid}{data.frame}(x, check = TRUE)

\method{as.data.frame}{uid}(x, ...)

get_uid_(sciname, verbose = TRUE, rows = NA)
}
\arguments{
\item{sciname}{character; scientific name.}

\item{ask}{logical; should get_tsn be run in interactive mode?
If TRUE and more than one TSN is found for the species, the user is asked for
input. If FALSE NA is returned for multiple matches.}

\item{verbose}{logical; If TRUE the actual taxon queried is printed on the console.}

\item{rows}{numeric; Any number from 1 to inifity. If the default NA, all rows are considered.
Note that this function still only gives back a uid class object with one to many identifiers.
See \code{\link[taxize]{get_uid_}} to get back all, or a subset, of the raw data that you are
presented during the ask process.}

\item{x}{Input to \code{\link{as.uid}}}

\item{check}{logical; Check if ID matches any existing on the DB, only used in
\code{\link{as.uid}}}

\item{...}{Ignored}
}
\value{
A vector of unique identifiers (UID). If a taxon is not found NA.
If more than one UID is found the function asks for user input (if ask = TRUE),
otherwise returns NA. Comes with an attribute \emph{match} to investigate the
reason for NA (either 'not found', 'found' or if ask = FALSE 'multi match').
If \code{ask=FALSE} and \code{rows} does not equal NA, then a data.frame is
given back, but not of the uid class, which you can't pass on to other functions
as you normally can.
}
\description{
Retrieve the Unique Identifier (UID) of a taxon from NCBI taxonomy browser.
}
\examples{
\dontrun{
get_uid(c("Chironomus riparius", "Chaetopteryx"))
get_uid(c("Chironomus riparius", "aaa vva"))

# When not found
get_uid("howdy")
get_uid(c("Chironomus riparius", "howdy"))

# specify rows to limit choices available
get_uid('Dugesia') # user prompt needed
get_uid('Dugesia', rows=1) # 2 choices, so returns only 1 row, so no choices
get_uid('Dugesia', ask = FALSE) # returns NA for multiple matches
get_uid('Dugesia', ask = FALSE) # or specify rows to get data back

# Go to a website with more info on the taxon
res <- get_uid("Chironomus riparius")
browseURL(attr(res, "uri"))

# Convert a uid without class information to a uid class
as.uid(get_uid("Chironomus riparius")) # already a uid, returns the same
as.uid(get_uid(c("Chironomus riparius","Pinus contorta"))) # same
as.uid(315567) # numeric
as.uid(c(315567,3339,9696)) # numeric vector, length > 1
as.uid("315567") # character
as.uid(c("315567","3339","9696")) # character vector, length > 1
as.uid(list("315567","3339","9696")) # list, either numeric or character
## dont check, much faster
as.uid("315567", check=FALSE)
as.uid(315567, check=FALSE)
as.uid(c("315567","3339","9696"), check=FALSE)
as.uid(list("315567","3339","9696"), check=FALSE)

(out <- as.uid(c(315567,3339,9696)))
data.frame(out)
as.uid( data.frame(out) )

# Get all data back
get_uid_("Puma concolor")
get_uid_("Dugesia")
get_uid_("Dugesia", rows=2)
get_uid_("Dugesia", rows=1:2)
get_uid_(c("asdfadfasd","Pinus contorta"))
}
}
\author{
Eduard Szoecs, \email{eduardszoecs@gmail.com}
}
\seealso{
\code{\link[taxize]{get_tsn}}, \code{\link[taxize]{classification}}
}

