% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/apg_lookup.R
\name{apg_lookup}
\alias{apg_lookup}
\title{Lookup in the APGII taxonomy and replace family names.}
\usage{
apg_lookup(taxa, rank = "family")
}
\arguments{
\item{taxa}{Taxonomic name to lookup a synonym for in APGII taxonomy.}

\item{rank}{Taxonomic rank to lookup a synonym for. One of family or order.}
}
\value{
A APGII family or order name, or the original name if no match.
}
\description{
Lookup in the APGII taxonomy and replace family names.
}
\examples{
# New name found in the APGII taxonomy
apg_lookup(taxa = "Hyacinthaceae", rank = "family")
apg_lookup(taxa = "Poaceae", rank = "family")

# Name not found in the APGII taxonomy
apg_lookup(taxa = "Asteraceae", rank = "family")
}

