% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy.R
\name{is_stem}
\alias{is_stem}
\title{Check if taxa are stems}
\usage{
is_stem(x)
}
\arguments{
\item{x}{An object with taxonomic relationships, like \link{taxonomy} objects.}
}
\description{
Check if each taxon is a stem. A stem is any taxa from a root to the first taxon with multiple subtaxa.
}
\examples{
x <- taxonomy(c('Carnivora', 'Felidae', 'Panthera', 'Panthera leo',
                'Panthera tigris'),
              supertaxa = c(NA, 1, 2, 3, 3))
is_stem(x)

}
\seealso{
Other stem functions: 
\code{\link{stems}()}
}
\concept{stem functions}
