% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{print_several_tables}
\alias{print_several_tables}
\title{Print several tables}
\usage{
print_several_tables(dat, indent, sep1, sep2, headings = NULL, ...)
}
\arguments{
\item{dat}{A \code{list} of objects that can be printed, usually \code{data.frame}s
or \code{Tatoo_table}s}

\item{indent}{a scalar character specifing the indent symbols (e.g. "  ")}

\item{sep1}{\code{character} or \code{numeric}. Seperator above the first and
below the last table.  If character a sep line is created using this
character (i.e. ------). If numeric, that many blank rows are inserted.}

\item{sep2}{\code{character} or \code{numeric}. Spacing between the tables.
Like \code{sep1}}

\item{headings}{\code{character} vector of the same length as \code{dat},
specifiying headings to be inserted above each table.}

\item{...}{passed on to \code{\link{print}}}
}
\value{
\code{dat} (invisibly)
}
\description{
Internal function used by \code{print.Stacked_table} and
\code{print.Tatoo_report}
}
