% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_lines.R
\name{as_lines}
\alias{as_lines}
\alias{as_lines.data.frame}
\alias{as_lines.Tagged_table}
\alias{as_lines.Mashed_table}
\alias{as_lines.Stacked_table}
\alias{as_lines.Composite_table}
\alias{as_lines.Tatoo_report}
\alias{as_lines.TT_meta}
\title{Create a line-by-line text representation of an R Object}
\usage{
as_lines(x, color = TRUE, ...)

\method{as_lines}{data.frame}(x, color = TRUE, ...)

\method{as_lines}{Tagged_table}(x, color = TRUE, ...)

\method{as_lines}{Mashed_table}(x, color = TRUE, mash_method = attr(x,
  "mash_method"), insert_blank_row = attr(x, "insert_blank_row"),
  id_vars = attr(x, "id_vars"), ...)

\method{as_lines}{Stacked_table}(x, color = TRUE, ...)

\method{as_lines}{Composite_table}(x, color = TRUE, ...)

\method{as_lines}{Tatoo_report}(x, color = TRUE, ...)

\method{as_lines}{TT_meta}(x, color = TRUE, ...)
}
\arguments{
\item{x}{Any \R object.}

\item{color}{Use colors (via \link{colt})}

\item{...}{passed on methods.}

\item{mash_method}{either \code{"row"} or \code{"col"}. Should the tables be mashed
together with alternating rows or with alternating columns?}

\item{insert_blank_row}{Only if mashing rows: logical. Whether to insert
blank rows between mash-groups. \emph{Warning: this converts all columns to
character.} Use with care.}

\item{id_vars}{Only if mashing columns: one ore more colnames of the tables
to be mashed. If supplied, columns of both input tables are combined with
\code{\link[=merge]{merge()}}, otherwise \code{\link[=cbind]{cbind()}} is used.}
}
\value{
A character vector (one element per line).
}
\description{
Creates a line-by-line representation of an \R Obeject (usually a
\code{Tatoo_table}). This is the function powers all \code{Tatoo_table} print methods.
}
