% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taskscheduleR.R
\name{taskscheduler_stop}
\alias{taskscheduler_stop}
\alias{taskcheduler_stop}
\title{Stop the run of a specific task which is running in the Windows task scheduler.}
\usage{
taskscheduler_stop(taskname)
}
\arguments{
\item{taskname}{the name of the task to stop. See the example.}
}
\value{
the system call to schtasks /End
}
\description{
Stop the run of a specific task which is running in the Windows task scheduler.
}
\examples{
\dontrun{
myscript <- system.file("extdata", "helloworld.R", package = "taskscheduleR")
taskscheduler_create(taskname = "myfancyscript", rscript = myscript, 
 schedule = "ONCE", starttime = format(Sys.time() + 10*60, "\%H:\%M"))

taskscheduler_runnow("myfancyscript")
Sys.sleep(5)
taskscheduler_stop("myfancyscript")


taskscheduler_delete(taskname = "myfancyscript")
}
}
